<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sharingdb', function (Blueprint $table) {
            $table->id();

            // L’utilisateur qui partage
            $table->foreignId('owner_user_id')
                  ->constrained('users')
                  ->cascadeOnDelete();

            // Le point partagé
            $table->foreignId('point_id')
                  ->constrained('points')
                  ->cascadeOnDelete();

            // Le destinataire
            $table->foreignId('target_user_id')
                  ->constrained('users')
                  ->cascadeOnDelete();

            $table->dateTime('start_at')->nullable();
            $table->dateTime('end_at')->nullable();

            $table->timestamps();

            // Empêcher les doublons exacts
            $table->unique(['owner_user_id','point_id','target_user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sharingdb');
    }
};