<?php

// database/migrations/2025_09_11_000000_create_societydb_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('societydb', function (Blueprint $table) {
            $table->id();
            $table->timestamp('subscribed_at')->nullable();   // date d'inscription
            $table->string('name');                           // nom
            $table->string('street')->nullable();             // rue
            $table->string('postcode', 32)->nullable();       // code postal
            $table->string('city', 120)->nullable();          // ville
            $table->string('country', 120)->nullable();       // pays (texte libre) 
            $table->string('phone', 64)->nullable();          // numéro de téléphone
            $table->string('email')->nullable();              // email
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('societydb');
    }
};