<?php

// database/migrations/2025_09_11_000001_create_societydb_user_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('societydb_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societydb')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['society_id','user_id']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('societydb_user');
    }
};