<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('points', 'favoris')) {
            Schema::table('points', function (Blueprint $table) {
                $table->unsignedInteger('favoris')->default(0)->after('floor');
            });
        }
        if (!Schema::hasColumn('points', 'serial')) {
            Schema::table('points', function (Blueprint $table) {
                $table->string('serial')->nullable()->after('photo');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('users', 'favoris')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('favoris');
            });
        }
        if (Schema::hasColumn('users', 'serial')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('serial');
            });
        }
    }
};
