<?php

// database/migrations/2025_10_07_000001_add_recipient_email_to_sharings.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('sharingdb', function (Blueprint $table) {
            // allow either a registered user OR a raw email
            $table->unsignedBigInteger('target_user_id')->nullable()->change();
            $table->string('recipient_email')->nullable()->index()->after('target_user_id');
        });
    }

    public function down(): void
    {
        Schema::table('sharingdb', function (Blueprint $table) {
            $table->dropColumn('recipient_email');
            // if needed, revert target_user_id to not nullable (only if your data allows it)
            // $table->unsignedBigInteger('target_user_id')->nullable(false)->change();
        });
    }
};