<?php

// database/migrations/2025_10_13_000000_create_itineraries_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('itineraries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('owner_user_id');     // admin pro (ou admin id=1)
            $table->unsignedBigInteger('assigned_user_id');  // user pro exécutant le parcours
            $table->unsignedBigInteger('society_id')->nullable(); // optionnel si utile
            $table->string('name', 255);
            $table->date('scheduled_date')->nullable();      // jour du parcours
            $table->timestamps();

            $table->foreign('owner_user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('assigned_user_id')->references('id')->on('users')->cascadeOnDelete();
            // society_id si table s'appelle 'societydb'
            $table->foreign('society_id')->references('id')->on('societydb')->nullOnDelete();
        });
    }
    public function down(): void {
        Schema::dropIfExists('itineraries');
    }
};