<?php

// database/migrations/2025_10_13_000001_create_itinerary_points_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('itinerary_points', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('itinerary_id');
            $table->unsignedBigInteger('point_id');
            $table->unsignedInteger('sort_order')->default(1);  // ordre de passage
            $table->timestamp('planned_at')->nullable();         // heure prévue d’arrivée
            $table->boolean('done')->default(false);             // réalisé / non réalisé
            $table->timestamp('rescheduled_at')->nullable();     // nouvelle heure éventuelle
            $table->text('comment')->nullable();                 // commentaire libre
            $table->timestamps();

            $table->foreign('itinerary_id')->references('id')->on('itineraries')->cascadeOnDelete();
            $table->foreign('point_id')->references('id')->on('points')->cascadeOnDelete();
        });
    }
    public function down(): void {
        Schema::dropIfExists('itinerary_points');
    }
};