<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::table('itinerary_points', function (Blueprint $table) {
            if (!Schema::hasColumn('itinerary_points','arrival_at'))     $table->timestamp('arrival_at')->nullable()->after('sort_order');
            if (!Schema::hasColumn('itinerary_points','done'))           $table->boolean('done')->default(false)->after('arrival_at');
            if (!Schema::hasColumn('itinerary_points','done_at'))        $table->timestamp('done_at')->nullable()->after('done');
            if (!Schema::hasColumn('itinerary_points','rescheduled_at')) $table->timestamp('rescheduled_at')->nullable()->after('done_at');
            if (!Schema::hasColumn('itinerary_points','comment'))        $table->text('comment')->nullable()->after('rescheduled_at');
        });
    }
    public function down(): void {
        Schema::table('itinerary_points', function (Blueprint $table) {
            $table->dropColumn(['arrival_at','done','done_at','rescheduled_at','comment']);
        });
    }
};
