<?php

// database/migrations/2025_10_14_170000_create_itinerary_user_pivot.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void {
        Schema::create('itinerary_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('itinerary_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
            $table->unique(['itinerary_id','user_id']);
        });

        // Make assigned_user_id nullable before backfill
        if (Schema::hasColumn('itineraries','assigned_user_id')) {
            Schema::table('itineraries', function (Blueprint $table) {
                $table->unsignedBigInteger('assigned_user_id')->nullable()->change();
            });

            // Backfill pivot from old single assignment (if any)
            DB::statement("
                INSERT INTO itinerary_user (itinerary_id, user_id, created_at, updated_at)
                SELECT id, assigned_user_id, NOW(), NOW()
                FROM itineraries
                WHERE assigned_user_id IS NOT NULL
            ");
        }
    }

    public function down(): void {
        Schema::dropIfExists('itinerary_user');
        // (optional) revert assigned_user_id to NOT NULL if you want
    }
};