<?php

// database/migrations/2025_10_14_170100_unique_itinerary_name_per_owner.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('itineraries', function (Blueprint $table) {
            // add composite unique (owner_user_id, name)
            $table->unique(['owner_user_id','name'], 'itins_owner_name_unique');
        });
    }
    public function down(): void {
        Schema::table('itineraries', function (Blueprint $table) {
            $table->dropUnique('itins_owner_name_unique');
        });
    }
};