<?php

// database/migrations/2025_10_14_170200_rename_done_at_to_validated_at.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('itinerary_points', function (Blueprint $table) {
            if (Schema::hasColumn('itinerary_points','done_at') && !Schema::hasColumn('itinerary_points','validated_at')) {
                $table->timestamp('validated_at')->nullable()->after('done');
            }
            if (Schema::hasColumn('itinerary_points','done_at')) {
                // copy data (simple DB-level copy; or do it in a separate DB::statement)
            }
        });

        // Copy values from done_at to validated_at (if column existed)
        \DB::statement("UPDATE itinerary_points SET validated_at = done_at WHERE validated_at IS NULL");

        // Drop old column
        Schema::table('itinerary_points', function (Blueprint $table) {
            if (Schema::hasColumn('itinerary_points','done_at')) {
                $table->dropColumn('done_at');
            }
            // Ensure rescheduled_at exists 
            if (!Schema::hasColumn('itinerary_points','rescheduled_at')) {
                $table->timestamp('rescheduled_at')->nullable()->after('validated_at');
            }
        });
    }

    public function down(): void {
        Schema::table('itinerary_points', function (Blueprint $table) {
            if (!Schema::hasColumn('itinerary_points','done_at')) {
                $table->timestamp('done_at')->nullable()->after('done');
            }
        });
        \DB::statement("UPDATE itinerary_points SET done_at = validated_at WHERE validated_at IS NOT NULL");
        Schema::table('itinerary_points', function (Blueprint $table) {
            if (Schema::hasColumn('itinerary_points','validated_at')) $table->dropColumn('validated_at');
            // keep rescheduled_at
        });
    }
};