<?php

// database/migrations/2025_10_15_000000_create_reporting_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('reporting', function (Blueprint $table) {
            $table->id();
            $table->foreignId('point_id')->constrained('points')->cascadeOnDelete();
            $table->string('email')->nullable();         // reporter email (optional)
            $table->text('message');                     // report reason/details
            $table->timestamp('resolved')->nullable();   // null until resolved
            $table->timestamps();                        // created_at = submit time
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('reporting');
    }
};