<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('users_points_favorite', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('point_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            $table->unique(['user_id', 'point_id']); // un favori unique par user/point
        });
    }

    public function down(): void {
        Schema::dropIfExists('users_points_favorite');
    }
};