<?php

// database/migrations/2025_10_XX_000000_create_itinerary_points_user_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('itinerary_points_user', function (Blueprint $t) {
            $t->id();

            $t->unsignedBigInteger('itinerary_id');
            $t->unsignedBigInteger('point_id');
            $t->unsignedBigInteger('user_id');

            $t->unsignedInteger('sort_order')->default(0);
            $t->timestamp('planned_at')->nullable();
            $t->timestamp('arrival_at')->nullable();
            $t->boolean('done')->default(false);
            $t->timestamp('validated_at')->nullable();
            $t->timestamp('rescheduled_at')->nullable();
            $t->text('comment')->nullable();

            $t->timestamps();

            // FK (ON DELETE CASCADE pour nettoyer quand on supprime l’itinéraire / le point / le user)
            //$t->foreign('itinerary_id')->references('id')->on('itineraries')->onDelete('cascade');
            //$t->foreign('point_id')->references('id')->on('points')->onDelete('cascade');
            $t->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            // Un enregistrement par (itinéraire, point, utilisateur)
            $t->unique(['itinerary_id','point_id','user_id'], 'ipu_unique');
            $t->index(['user_id','itinerary_id']);
            $t->index(['itinerary_id','sort_order']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('itinerary_points_user');
    }
};
