<?php

// database/migrations/2025_10_22_000001_fix_ipu_unique_index.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('itinerary_points_user', function (Blueprint $table) {
            // 1) Supprime l'ancien unique (nommé 'ipu_unique' d'après le log)
            $table->dropUnique('ipu_unique'); // si le nom diffère, adapte-le

            // 2) Nouveau unique incluant l'ordre
            $table->unique(
                ['itinerary_id','user_id','point_id','sort_order'],
                'ipu_it_user_point_order_unique'
            );
        });
    }

    public function down(): void
    {
        Schema::table('itinerary_points_user', function (Blueprint $table) {
            $table->dropUnique('ipu_it_user_point_order_unique');
            $table->unique(['itinerary_id','point_id','user_id'], 'ipu_unique');
        });
    }
};