function resizeDiv() {
    document.querySelectorAll('.full-height').forEach(div => {
        div.style.height = window.innerHeight + 'px';
    });
}

// appel initial
resizeDiv();

// recalcul si l’utilisateur redimensionne
window.addEventListener('resize', resizeDiv);





// Fonction pour vérifier si l'image doit être cachée

function logDivTop(selector) {
    const el = document.querySelector(selector);
    if (!el) {
        console.warn(`Élément ${selector} introuvable`);
        return;
    }

    window.addEventListener("scroll", () => {
        const rect = el.getBoundingClientRect();
        console.log(`${selector} → top: ${rect.top.toFixed(0)}px`);
    });
}

// Exemple : suivre .overlay-div
logDivTop(".overlay-div");
logDivTop("#floatingImage");



function trackElementCoords(selector) {
    const el = document.querySelector(selector);
    const box = document.getElementById("coordsBox");

    if (!el || !box) return;

    function updateCoords() {
        const rect = el.getBoundingClientRect();
        box.textContent =
            `${selector} → top:${rect.top.toFixed(0)}px, left:${rect.left.toFixed(0)}px`;

        console.log(box.textContent);
    }

    // au scroll et au resize
    window.addEventListener("scroll", updateCoords);
    window.addEventListener("resize", updateCoords);

    // première mise à jour
    updateCoords();
}



function checkImageVisibility() {
    const floatingImage = document.getElementById('floatingImage');
    const overlayDiv = document.querySelector('.overlay-div');

    // Obtenir les positions des éléments
    const overlayRect = overlayDiv.getBoundingClientRect();
    const imageRect = floatingImage.getBoundingClientRect();

    // Vérifier si l'image chevauche avec la div overlay
    const isOverlapping = (
        imageRect.top < overlayRect.bottom &&
        imageRect.bottom > overlayRect.top &&
        imageRect.left < overlayRect.right &&
        imageRect.right > overlayRect.left
    );

    // Masquer ou afficher l'image
    if (isOverlapping) {
        floatingImage.classList.add('hidden');
    } else {
        floatingImage.classList.remove('hidden');
    }
}

// Écouter les événements avec optimisation des performances
window.addEventListener('scroll', function () {
    trackElementCoords('.overlay-div');
    trackElementCoords('#floatingImage');

    //requestTick();
    //setTimeout(resetTick, 16); // ~60fps
}, { passive: true });

window.addEventListener('resize', function () {
    // Debounce pour éviter trop d'appels
    clearTimeout(window.resizeTimer);
    window.resizeTimer = setTimeout(checkImageVisibility, 250);
});

// Gestion du changement d'orientation mobile
window.addEventListener('orientationchange', function () {
    setTimeout(checkImageVisibility, 500); // Délai pour finir l'animation
});

// Vérification initiale
document.addEventListener('DOMContentLoaded', checkImageVisibility);

// Animation d'entrée pour l'image
window.addEventListener('load', function () {
    const floatingImage = document.getElementById('floatingImage');
    if (floatingImage) {
        floatingImage.style.transform = 'translateY(-50%) scale(1)';
        floatingImage.style.opacity = '1';
    }
});

// // Gestion des interactions tactiles pour mobile
// if ('ontouchstart' in window) {
//     const floatingImage = document.getElementById('floatingImage');
//     if (floatingImage) {
//         floatingImage.addEventListener('touchstart', function (e) {
//             this.style.transform = 'translateY(-50%) scale(0.95)';
//         });

//         floatingImage.addEventListener('touchend', function (e) {
//             this.style.transform = 'translateY(-50%) scale(1)';
//         });
//     }
//}

// JS pour le menu hamburger

document.addEventListener("DOMContentLoaded", () => {
    const toggle = document.querySelector(".nav-toggle");
    const nav = document.querySelector(".nav-actions");

    toggle.addEventListener("click", () => {
        nav.classList.toggle("active");
    });
});
