// resources/js/app.js
import '../css/app.css'
import './bootstrap'
import 'leaflet/dist/leaflet.css';
import L from 'leaflet';

import { createInertiaApp } from '@inertiajs/vue3'
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers'
import { createApp, h } from 'vue'
import { route } from 'ziggy-js'   // import nommé

const appName = import.meta.env.VITE_APP_NAME || 'Vereego'

// Fix des icônes si besoin (Vite + Leaflet)
// import iconUrl from 'leaflet/dist/images/marker-icon.png';
// import iconRetinaUrl from 'leaflet/dist/images/marker-icon-2x.png';
// import shadowUrl from 'leaflet/dist/images/marker-shadow.png';
// L.Icon.Default.mergeOptions({ iconUrl, iconRetinaUrl, shadowUrl });

window.L = L; // expose pour l'utiliser dans Blade


createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue')),
    setup({ el, App, props, plugin }) {
        const app = createApp({ render: () => h(App, props) }).use(plugin)

        // expose route() qui s’appuie sur window.Ziggy (injecté par @routes)
        app.config.globalProperties.route = (name, params = {}, absolute = false) =>
            route(name, params, absolute, window.Ziggy)

        app.mount(el)
    },
    progress: { color: '#4B5563' },
})

// --- Init carte avec Leaflet + locatecontrol ---
export async function initMap() {
    const { default: L } = await import('leaflet')
    await import('leaflet/dist/leaflet.css')

    // rendre Leaflet global pour les plugins UMD
    window.L = L

    // corriger les icônes
    const iconRetinaUrl = new URL('leaflet/dist/images/marker-icon-2x.png', import.meta.url).toString()
    const iconUrl = new URL('leaflet/dist/images/marker-icon.png', import.meta.url).toString()
    const shadowUrl = new URL('leaflet/dist/images/marker-shadow.png', import.meta.url).toString()
    L.Icon.Default.mergeOptions({ iconRetinaUrl, iconUrl, shadowUrl })

    // importer locatecontrol (après avoir défini window.L)
    await import('leaflet.locatecontrol/dist/L.Control.Locate.min.js')
    await import('leaflet.locatecontrol/dist/L.Control.Locate.min.css')

    // créer la carte
    const map = L.map('map').setView([48.8566, 2.3522], 13)
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors',
        maxZoom: 19,
    }).addTo(map)

    // bouton centrer sur ma position
    if (L.control && typeof L.control.locate === 'function') {
        L.control.locate({
            position: 'topleft',
            flyTo: true,
            strings: { title: 'Centrer sur ma position' },
        }).addTo(map)
    } else {
        console.warn('LocateControl non chargé')
    }

    return map
}

// pour être appelé depuis Blade
if (typeof window !== 'undefined') {
    window.initMap = initMap
}