@extends('layouts.base')
@section('title', __('Mon compte'))

@section('content')


{{-- DEBUG (temporaire) --}}
@php
    $u = auth()->user();
    $names = [];
    if ($u && (int)$u->id !== 1) {
        try { $u->loadMissing(['societies:id,name']); $names = $u->societies->pluck('name')->all(); }
        catch (\Throwable $e) {
            $names = \DB::table('societydb_user')->join('societydb','societydb.id','=','societydb_user.society_id')
                        ->where('societydb_user.user_id',$u->id)->pluck('societydb.name')->all();
        }
    }
@endphp
<p style="opacity:.6">DEBUG sociétés : {{ implode(', ', $names) ?: '—' }}</p>





<div class="wrap" style="max-width:760px;margin:24px auto">
    @if(session('ok')) <div class="ok">{{ session('ok') }}</div> @endif
    @if($errors->any())
        <div class="alert">
            <ul style="margin:0 0 0 16px">
                @foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach
            </ul>
        </div>
    @endif
    @php $pt = $p ?? null; @endphp;

    @if(!$pt)
        <div class="alert">
            {{ __('Ce waypoint est introuvable ou n’a pas été fourni.') }}
        </div>
    @else


        @php
            $names = $societyNames ?? [];
            if (empty($names)) {
                $u = auth()->user();
                if ($u && (int)$u->id !== 1) {
                    try {
                        $u->loadMissing(['societies:id,name']);
                        $names = $u->societies->pluck('name')->filter()->values()->all();
                    } catch (\Throwable $e) {
                        $names = \DB::table('societydb_user')
                            ->join('societydb', 'societydb.id', '=', 'societydb_user.society_id')
                            ->where('societydb_user.user_id', $u->id)
                            ->orderBy('societydb.name')
                            ->pluck('societydb.name')
                            ->all();
                    }
                }
            }
        @endphp

        @auth
            @if((int)auth()->id() !== 1)
                <div class="card" style="margin-top:16px;">
                    <div class="card-header">
                        <div class="title">{{ __('Company / Companies') }}</div>
                        <div class="subtitle" style="color:#6b7280;">
                            {{ __('These links are managed by your administrator.') }}
                        </div>
                    </div>
                    <div class="card-body">
                        @if(!empty($names))
                            <ul style="list-style:none; padding:0; margin:0; display:grid; gap:.5rem;">
                                @foreach($names as $name)
                                    <li>
                                        <input type="text" value="{{ $name }}" readonly
                                            style="width:100%; background:#0e1018; border:1px solid #1f2430; border-radius:8px; padding:.5rem .75rem; color:#c8ccd3;">
                                    </li>
                                @endforeach
                            </ul>
                        @else
                            <div class="alert" style="margin:0;">
                                {{ __('No company linked to your account.') }} PAsske !
                            </div>
                        @endif
                    </div>
                </div>
            @endif
        @endauth


        <form method="POST" action="{{ lr('user.update', ['user' => $user->id]) }}" class="grid" style="display:grid;gap:12px;grid-template-columns:1fr;max-width:760px">
            @csrf @method('PUT')

            <label for="firstname" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
                <span style="min-width:140px">{{ __('Prénom') }}</span>
                <input id="firstname" type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}" class="input" style="flex:1">
            </label>

            <label for="lastname" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
                <span style="min-width:140px">{{ __('Nom') }}</span>
                <input id="lastname" type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}" class="input" style="flex:1">
            </label>

            <label for="email" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
                <span style="min-width:140px">{{ __('Email') }}</span>
                <input id="email" type="email" name="email" value="{{ old('email', $user->email) }}" class="input" style="flex:1">
            </label>

            <div style="display:flex;gap:8px;justify-content:flex-end;margin-top:8px">
                <a class="btn ghost" href="{{ lr('welcome') }}">{{ __('Annuler') }}</a>
                <button class="btn primary" type="submit">{{ __('Enregistrer') }}</button>

                <form method="POST" action="{{ lr('user.destroy', ['user' => $user->id]) }}"
                    onsubmit="return confirm('{{ __('Supprimer votre compte ? Cette action est irréversible.') }}')"
                    style="display:inline">
                    @csrf @method('DELETE')
                    <button class="btn danger" type="submit">{{ __('Supprimer') }}</button>
                </form>
            </div>
        </form>
    @endif
</div>
@endsection