{{-- resources/views/pro/itins/index.blade.php --}}
@extends('layouts.base')

@section('title', __('Itineraries'))

@section('content')
@php
    /** @var \Illuminate\Pagination\LengthAwarePaginator|\Illuminate\Support\Collection $itineraries */
    $itineraries = $itineraries ?? collect();
    $isAdmin  = (int)(auth()->id() ?? 0) === 1;
    $baseName = $isAdmin ? 'admin.itins' : 'pro.itins';
    $locale   = app()->getLocale();
@endphp

<div class="wrap">
    <div class="flex items-center justify-between" style="display:flex;align-items:center;justify-content:space-between;gap:12px;margin-bottom:12px;">
        <h2 style="margin:0">{{ __('Itineraries') }}</h2>

        {{-- Create button (admin not localized / pro localized) --}}
        <a class="btn primary" href="{{ $isAdmin
            ? route('admin.itins.create')
            : route('pro.itins.create', ['locale'=>$locale]) }}">
            + {{ __('Create itinerary') }}
        </a>
    </div>

    {{-- Flash messages --}}
    @if(session('ok'))
        <div class="ok">{{ session('ok') }}</div>
    @endif
    @if($errors->any())
        <div class="alert danger">
            <strong>{{ __('Errors') }}:</strong>
            <ul style="margin:6px 0 0 16px;">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Empty state --}}
    @if(($itineraries instanceof \Illuminate\Contracts\Support\Htmlable) ? false : $itineraries->isEmpty())
        <div class="card">
            <div class="card-body">
                {{ __('No itinerary yet.') }}
            </div>
        </div>
    @else
        <div class="table-responsive" style="overflow:auto">
            <table class="table" style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr style="text-align:left; border-bottom:1px solid var(--border-color, #222);">
                        <th style="padding:8px;">{{ __('Name') }}</th>
                        <th style="padding:8px;">{{ __('assignedUsers') }}</th>
                        <th style="padding:8px;">{{ __('Assignees') }}</th>
                        <th style="padding:8px;">{{ __('Points') }}</th>
                        <th style="padding:8px;">{{ __('Scheduled date') }}</th>
                        <th style="padding:8px;">{{ __('Created') }}</th>
                        <th style="padding:8px; width:1%;">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($itineraries as $it)
                    @php
                        // Null-safe owner
                        $ownerName = trim(($it->owner?->lastname ?? '—').' '.($it->owner?->firstname ?? ''));

                        // Join assignees safely
                        $assignees = collect($it->users ?? [])
                            ->map(fn($u) => trim(($u->lastname ?? '').' '.($u->firstname ?? '')))
                            ->filter()
                            ->join(', ');

                        // Points count (if items eager-loaded, else fallback)
                        $pointsCount = isset($it->items) ? $it->items->count() : ((int)($it->items_count ?? 0));

                        // Dates safe format
                        $scheduled = $it->scheduled_date ? \Illuminate\Support\Carbon::parse($it->scheduled_date)->format('Y-m-d') : '—';
                        $created   = $it->created_at ? $it->created_at->format('Y-m-d H:i') : '—';

                        // Route helpers per context (admin/pro)
                        $editUrl = $isAdmin
                            ? route('admin.itins.edit', ['itinerary'=>$it->id])
                            : route('pro.itins.edit', ['locale'=>$locale,'itinerary'=>$it->id]);

                        $mapUrl = $isAdmin
                            ? route('admin.itins.map', ['itinerary'=>$it->id])
                            : route('pro.itins.map',   ['locale'=>$locale,'itinerary'=>$it->id]);

                        $delAction = $isAdmin
                            ? route('admin.itins.destroy', ['itinerary'=>$it->id])
                            : route('pro.itins.destroy',   ['locale'=>$locale,'itinerary'=>$it->id]);
                    @endphp
                    <tr style="border-bottom:1px solid var(--border-color, #222);">
                        <td style="padding:8px;">
                            <strong>{{ $it->name }}</strong>
                            @if(!empty($it->society_id))
                                <div class="muted" style="font-size:.85em">
                                    {{ __('Company ID') }}: {{ $it->society_id }}
                                </div>
                            @endif
                        </td>
                        <td style="padding:8px;">
                            {{ $ownerName }}
                            @if(method_exists($it->owner ?? null, 'societies'))
                                <div class="muted" style="font-size:.85em;">
                                    {{-- First company name if available --}}
                                    {{ $it->owner?->societies?->first()?->name ?? __('No company') }}
                                </div>
                            @endif
                        </td>
                        <td style="padding:8px;">
                            <span class="muted">{{ $assignees ?: __('No assignees') }}</span>
                        </td>
                        <td style="padding:8px;">
                            {{ $pointsCount > 0 ? $pointsCount : '—' }}
                        </td>
                        <td style="padding:8px;">
                            {{ $scheduled }}
                        </td>
                        <td style="padding:8px;">
                            {{ $created }}
                        </td>
                        <td style="padding:8px; white-space:nowrap;">
                            {{-- Edit --}}
                            <a class="btn small ghost" href="{{ $editUrl }}">{{ __('Edit') }}</a>

                            {{-- Map (show itinerary path) --}}
                            <a class="btn small" href="{{ $mapUrl }}">{{ __('Map') }}</a>

                            {{-- Delete (confirm) --}}
                            <form method="POST" action="{{ $delAction }}" style="display:inline-block"
                                  onsubmit="return confirm('{{ __('Delete this itinerary?') }}');">
                                @csrf
                                @method('DELETE')
                                <button class="btn small danger" type="submit">{{ __('Delete') }}</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div style="margin-top:12px;">
            {{ $itineraries->links() }}
        </div>
    @endif
</div>
@endsection