@extends('layouts.base')
@section('content')

<div class="container" style="max-width:720px;margin:20px auto;font-family:system-ui,Segoe UI,Roboto,Arial">
  <h1 style="margin:0 0 12px">Éditer waypoint #{{ $point->id }}</h1>

  <form method="POST" action="{{ route('admin.points.update', $point) }}" style="display:grid;gap:10px" enctype="multipart/form-data">
        @csrf @method('PUT')

        <div style="display:grid;grid-template-columns:1fr 1fr;gap:10px">
            <label>Nom
                <input name="name" value="{{ old('name',$point->name) }}" required style="width:100%;padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
            {{-- Créateur du point (user_id) --}}
            <div class="form-field">
                <label for="user_id">{{ __('Creator / Assigned admin') }}</label>
                <select id="user_id" name="user_id" required>
                    @foreach($users as $u)
                        @php
                            $isAdmin = (int)($u->role_id ?? 0) === 1;
                            $isPro   = (int)($u->role_id ?? 0) === 2;
                            $society = $u->societies?->first()?->name;
                        @endphp
                        <option value="{{ $u->id }}" @selected(old('user_id', $point->user_id) == $u->id)>
                            {{ $u->lastname }} {{ $u->firstname }}
                            — {{ $u->email }}
                            @if($isPro && $society)
                                — {{ __('Company') }}: {{ $society }}
                            @endif
                            @if($isAdmin)
                                (Admin)
                            @elseif($isPro)
                                (Pro)
                            @endif
                        </option>
                    @endforeach
                </select>
                <small class="muted">
                    {{ __('Reassign the waypoint owner to an Admin or a Pro Admin of a company.') }}
                </small>
            </div>
       </div>

        <div style="display:grid;grid-template-columns:1fr 1fr;gap:10px">
            <label>Latitude
                <input type="number" step="0.0000001" name="latitude" value="{{ old('latitude',$point->latitude) }}" required style="padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
            <label>Longitude
                <input type="number" step="0.0000001" name="longitude" value="{{ old('longitude',$point->longitude) }}" required style="padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
        </div>

        <label>Altitude
            <input type="number" step="0.01" name="altitude" value="{{ old('altitude',$point->altitude) }}" style="width:100%;padding:10px;border:1px solid #e5e7eb;border-radius:8px">
        </label>

        <label>Commentaire
            <input name="comment" value="{{ old('comment',$point->comment) }}" style="width:100%;padding:10px;border:1px solid #e5e7eb;border-radius:8px">
        </label>

        <label>Adresse 1
            <input name="address1" value="{{ old('address1',$point->address1) }}" style="width:100%;padding:10px;border:1px solid #e5e7eb;border-radius:8px">
        </label>

        <label>Adresse 2
            <input name="address2" value="{{ old('address2',$point->address2) }}" style="width:100%;padding:10px;border:1px solid #e5e7eb;border-radius:8px">
        </label>

        <div style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:10px">
            <label>Code postal
                <input name="postcode" value="{{ old('postcode',$point->postcode) }}" style="padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
            <label>Ville
                <input name="city" value="{{ old('city',$point->city) }}" style="padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
            <label>Pays (ISO)
                <input name="country_isocode" maxlength="3" value="{{ old('country_isocode',$point->country_isocode) }}" style="padding:10px;border:1px solid #e5e7eb;border-radius:8px">
            </label>
        </div>

        <label style="display:flex;gap:8px;align-items:center">
            <input type="checkbox" name="regenerate_qr" value="1"> Régénérer le QRCode
        </label>


        {{-- Photo --}}
        @php
            $photoUrl = ($point && !empty($point->photo))  
                ? Storage::url($point->photo)  
                : null;
        @endphp

        @if($photoUrl)
            <a href="{{ $photoUrl }}" target="_blank" rel="noopener">
                <img src="{{ $photoUrl }}" alt="Photo du point {{ $point->name }}" 
                    style="max-width:180px; height:auto; margin-bottom:10px;">
            </a>
        @else
            <div style="color:#6b7280;font-size:.9rem;padding:12px">
                {{ __('No photo') }}
            </div>
        @endif

        <input id="photo-input" name="photo" type="file" accept="image/*" hidden onchange="this.form.submit()">
        <input type="hidden" name="serial" value="{{ $point->serial }}">

        <button type="button" class="btn primary" 
                style="padding: 2px 18px !important;" 
                onclick="document.getElementById('photo-input').click()">
            {{ __('Import') }}
        </button>

        @if($photoUrl)
            <div style="font-size:.85rem; color:#a7acb4;">
                {{ __('Replace existing photo') }}
            </div>
        @else
            <div style="font-size:.85rem; color:#a7acb4;">
                {{ __('Add a photo') }}
            </div>
        @endif




        <div style="display:flex;gap:10px;margin-top:6px">
            <a href="{{ route('admin.points.index') }}" class="btn">Retour</a>
            <button class="btn" style="background:#0f172a;color:#fff">Enregistrer</button>
        </div>

    </form>

</div>

@endsection