{{-- resources/views/admin/points/index.blade.php --}}
@extends('layouts.base')

@php $pt = $p ?? null; @endphp
@section('title','Admin · Waypoints')

@section('content')
    <div class="wrap">

        {{-- Messages flash --}}
        @if(session('ok'))
            <div style="background:#ecfdf5;border:1px solid #10b98133;padding:10px;border-radius:8px;margin-bottom:12px">
                {{ session('ok') }}
            </div>
        @endif
        @if (session('status'))
            <div class="alert success" style="margin:8px 0">{{ session('status') }}</div>
        @endif

        <h1 style="margin:0 0 10px;">Admin · Waypoints</h1>

        {{-- Barre de recherche --}}
        <form method="GET" style="margin:12px 0;display:flex;gap:8px">
            <input type="text" name="q" value="{{ $q ?? '' }}" placeholder="Rechercher (nom, ville, CP, adresse)…"
                style="flex:1;padding:8px;border:1px solid #e5e7eb;border-radius:8px">
            <button class="btn">Filtrer</button>
        </form>

        {{-- Actions bulk --}}
        <div style="display:flex;gap:8px;flex-wrap:wrap;margin:10px 0">
            {{-- boutons / formulaires bulk --}}
            <form method="POST" action="{{ route('admin.points.bulk.fillAddresses') }}">
                @csrf
                <button class="btn small ghost" type="submit">{{ __('Compléter adresses (bulk)') }}</button>
            </form>

             <form method="POST" action="{{ route('admin.points.bulk.generateQrcodes') }}">
                @csrf
                <button type="submit" class="btn small ghost">
                    {{ __('Generate all QR codes') }}
                </button>
            </form>
            @if(session('qr_errors'))
                <details style="margin-top:.5rem">
                    <summary>{{ __('View errors') }} ({{ count(session('qr_errors')) }})</summary>
                    <ul>
                        @foreach(session('qr_errors') as $err)
                            <li>{{ $err }}</li>
                        @endforeach
                    </ul>
                </details>
            @endif

            <form method="POST" action="{{ route('admin.points.generateSerials') }}">
                @csrf
                <button class="btn small ghost" type="submit">{{ __('Generate missing Serials') }}</button>
            </form>

            <form method="POST" action="{{ route('admin.points.generateMissingQr') }}">
                @csrf
                <button class="btn small ghost" type="submit">{{ __('Generate missing QR codes') }}</button>
            </form>

            {{-- lien Éditer dans le tableau --}}
            {{-- <a class="btn" href="{{ route('admin.points.edit', $p) }}">Éditer</a>             --}}
        </div>

        @if(session('status'))
            <div class="ok">{{ session('status') }}</div>
        @endif

        {{-- Tableau --}}
        <div style="overflow:auto;border:1px solid #e5e7eb;border-radius:10px">
            <table style="width:100%;border-collapse:collapse;font-size:14px">
                <thead style="background:#f8fafc">
                    <tr>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">ID</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">Nom</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">Propriétaire</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">Adresse</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">Lat/Lng</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">QR</th>
                       <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">Serial</th>
                        <th style="padding:8px;border-bottom:1px solid #e5e7eb; text-align:right">Actions</th>
                    </tr>
                </thead>
                <tbody>
          @forelse(($points ?? []) as $point)
            <tr>
                <td style="padding:6px 8px;">{{ $point->id }}</td>
                <td style="padding:6px 8px;">{{ $point->name }}</td>
                <td style="padding:6px 8px;">{{ $point->user_id }}</td>
                <td style="padding:6px 8px;">{{ $point->address1 }}</td>
                <td style="padding:6px 8px;">
                    {{ $point->latitude }}, {{ $point->longitude }}
                </td>
                 <td style="padding:6px 8px;">
                    @if($point->qrcode)
                        {{-- <a href="{{ Storage::url($point->qrcode) }}" target="_blank">{{ __('Voir') }}</a>  --}}
                        @php
                            $qrUrl = $point->qrcode ? Storage::disk('public')->url($point->qrcode) : null; // /storage/qrcodes/xxx.svg
                        @endphp

                        @if($qrUrl)
                            <a href="{{ $qrUrl }}" target="_blank" rel="noopener">
                                <img
                                src="{{ $qrUrl }}"
                                alt="QR Code"
                                width="256" height="256"
                                loading="lazy" decoding="async"
                                style="display:block;max-width:100%;height:auto"
                                onerror="this.replaceWith(Object.assign(document.createElement('object'),{data:this.src,type:'image/svg+xml',width:this.width,height:this.height}));"
                                >
                            </a>
                            @else
                            <div class="alert">{{ __('QR code unavailable') }}</div>
                        @endif

                      @else
                        —
                    @endif
                </td>
                <td style="padding:6px 8px;">
                    {{ $point->serial ?? '—' }}
                </td>
               <td style="padding:6px 8px;display:flex;gap:.5rem;flex-wrap:wrap;">
                    <a class="btn small ghost" href="{{ route('admin.points.edit', $point->id) }}">{{ __('Edit') }}</a>

                    {{-- Exemple d’action PUT unique au point --}}
                    <form method="POST" action="{{ route('admin.points.update', $point->id) }}">
                        @csrf @method('PUT')
                        <input type="hidden" name="regen_qr" value="1">
                        <button class="btn small ghost" type="submit">{{ __('Regenerate QR') }}</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr><td colspan="7" style="padding:10px;">{{ __('No waypoints found') }}</td></tr>
        @endforelse
        </tbody>
    </table>
    <table style="width:100%;border-collapse:collapse;font-size:14px">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nom</th>
                <th>Utilisateur</th>
                <th>Ville</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($points as $point)
            <tr>
                <td>{{ $point->id }}</td>
                <td>{{ $point->name }}</td>
                <td>
                    @if($point->user)
                        {{ $point->user->name }}<br>
                        <small>{{ $point->user->email }}</small>
                    @else
                        <em>Utilisateur supprimé</em>
                    @endif
                </td>
                <td>{{ $point->city ?? '—' }}</td>

                <td>
                    {{-- Bouton vers la page du point --}}
                    <a href="{{ route('admin.points.show', $point->id) }}" 
                    class="btn btn-sm btn-primary"
                    style="margin-right:6px">
                    <i class="bi bi-geo"></i> Point
                    </a>

                    {{-- Bouton vers la page de l’utilisateur --}}
                    @if($point->user)
                        <a href="{{ route('admin.users.edit', $point->user->id) }}" 
                        class="btn btn-sm btn-secondary">
                        <i class="bi bi-person"></i> User
                        </a>
                    @endif
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    {{-- Pagination si fournie --}}
    @if(method_exists($points, 'links'))
        <div style="margin-top:12px;">{{ $points->links() }}</div>
    @endif
        </div>

        <div style="margin-top:12px">
            {{ $points->links() }}
        </div>

        {{-- Pagination si fournie --}}
        @if(method_exists($points, 'links'))
            <div style="margin-top:12px;">{{ $points->links() }}</div>
        @endif

    </div>
@endsection