@extends('layouts.base')

@section('title', 'Admin · Waypoint #'.$point->id)

@section('content')
    <div class="wrap" style="padding:20px 0">
        <a href="{{ route('admin.points.index') }}" class="btn" style="margin-bottom:12px;display:inline-flex;align-items:center;gap:6px">
            &larr; {{ __('Back to waypoints') }}
        </a>

        <div style="display:flex;flex-wrap:wrap;gap:24px;align-items:flex-start">
            <div style="flex:1 1 320px;min-width:280px">
                <h1 style="margin:0 0 12px">{{ __('Waypoint #:id', ['id' => $point->id]) }} · {{ $point->name ?? '—' }}</h1>

                <div style="border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff">
                    <dl style="margin:0;display:grid;grid-template-columns:max-content 1fr;row-gap:8px;column-gap:16px">
                        <dt style="font-weight:600;color:#4b5563">ID</dt>
                        <dd style="margin:0">{{ $point->id }}</dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Name') }}</dt>
                        <dd style="margin:0">{{ $point->name ?? '—' }}</dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Owner') }}</dt>
                        <dd style="margin:0">
                            @if($point->user)
                                <a href="{{ route('admin.users.edit', $point->user->id) }}" class="link">
                                    {{ $point->user->name }}
                                </a>
                                <div style="color:#6b7280;font-size:0.9em">{{ $point->user->email }}</div>
                            @else
                                <em>{{ __('Deleted user') }}</em>
                            @endif
                        </dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Address') }}</dt>
                        <dd style="margin:0">
                            {{ $point->address1 ?? '—' }}<br>
                            {{ $point->address2 ?? '' }}
                            @if($point->postcode || $point->city)
                                <div>{{ trim(($point->postcode ?? '').' '.($point->city ?? '')) }}</div>
                            @endif
                            @if($point->country_isocode)
                                <div>{{ $point->country_isocode }}</div>
                            @endif
                        </dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Coordinates') }}</dt>
                        <dd style="margin:0">
                            {{ $point->latitude ?? '—' }}, {{ $point->longitude ?? '—' }}<br>
                            <span style="color:#6b7280;font-size:0.9em">{{ __('Altitude') }}: {{ $point->altitude ?? '—' }}</span>
                        </dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Serial') }}</dt>
                        <dd style="margin:0">{{ $point->serial ?? '—' }}</dd>

                        <dt style="font-weight:600;color:#4b5563">{{ __('Comment') }}</dt>
                        <dd style="margin:0">{{ $point->comment ?? '—' }}</dd>
                    </dl>
                </div>

                <div style="display:flex;gap:10px;margin-top:16px;flex-wrap:wrap">
                    <a href="{{ route('admin.points.edit', $point) }}" class="btn">{{ __('Edit waypoint') }}</a>
                    <form method="POST" action="{{ route('admin.points.update', $point) }}">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="regen_qr" value="1">
                        <button type="submit" class="btn">{{ __('Regenerate QR') }}</button>
                    </form>
                </div>
            </div>

            <div style="flex:1 1 240px;max-width:360px">
                @php
                    $qrUrl = $point->qrcode ? Storage::disk('public')->url($point->qrcode) : null;
                    $photoUrl = $point->photo ? Storage::url($point->photo) : null;
                @endphp

                <div style="border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff;margin-bottom:16px">
                    <h2 style="margin:0 0 12px;font-size:1.1rem">QR Code</h2>
                    @if($qrUrl)
                        <a href="{{ $qrUrl }}" target="_blank" rel="noopener">
                            <img src="{{ $qrUrl }}" alt="QR code" style="width:100%;height:auto;max-width:260px;display:block;margin:0 auto"
                                loading="lazy" decoding="async"
                                onerror="this.replaceWith(Object.assign(document.createElement('object'),{data:this.src,type:'image/svg+xml',width:this.width,height:this.height}));">
                        </a>
                        <div style="margin-top:8px;font-size:0.9em;text-align:center">
                            <a href="{{ $qrUrl }}" target="_blank" rel="noopener">{{ __('Open original') }}</a>
                        </div>
                    @else
                        <div style="color:#6b7280">{{ __('No QR code available') }}</div>
                    @endif
                </div>

                <div style="border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff">
                    <h2 style="margin:0 0 12px;font-size:1.1rem">{{ __('Photo') }}</h2>
                    @if($photoUrl)
                        <a href="{{ $photoUrl }}" target="_blank" rel="noopener">
                            <img src="{{ $photoUrl }}" alt="{{ __('Point photo') }}"
                                style="width:100%;height:auto;border-radius:8px;display:block">
                        </a>
                    @else
                        <div style="color:#6b7280">{{ __('No photo provided') }}</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
