@extends('layouts.base')

@section('title', __('Unresolved Reports'))

@section('content')
<div class="wrap">
    <h2>{{ __('Unresolved Reports') }}</h2>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif

    @if($reports->isEmpty())
        <div class="alert">{{ __('No unresolved reports found.') }}</div>
    @else
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>{{ __('Waypoint') }}</th>
                    <th>{{ __('Email') }}</th>
                    <th>{{ __('Message excerpt') }}</th>
                    <th>{{ __('Date') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach($reports as $r)
                    <tr>
                        <td>{{ $r->id }}</td>
                        <td>
                            @if($r->point)
                                <a href="{{ lr('points.public', ['token' => $r->point->serial]) }}" target="_blank">
                                    {{ $r->point->name }}
                                </a>
                            @else
                                <em>{{ __('Deleted point') }}</em>
                            @endif
                        </td>
                        <td>{{ $r->email ?? '—' }}</td>
                        <td>{{ Str::limit($r->message, 60) }}</td>
                        <td>{{ $r->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('admin.reporting.show', $r->id) }}" class="btn small">
                                {{ __('View') }}
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>
@endsection