@extends('layouts.base')

@section('title', __('Report #').$report->id)

@section('content')
<div class="wrap">
    <h2>{{ __('Report details') }}</h2>

    <div class="card" style="max-width:700px;">
        <div class="card-header">
            <strong>{{ __('Waypoint') }}:</strong>
            @if($report->point)
                <a href="{{ lr('points.public', ['token' => $report->point->serial]) }}" target="_blank">
                    {{ $report->point->name }}
                </a>
            @else
                <em>{{ __('Deleted point') }}</em>
            @endif
        </div>

        <div class="card-body">
            <p><strong>{{ __('Reporter email') }}:</strong> {{ $report->email ?? '—' }}</p>
            <p><strong>{{ __('Created at') }}:</strong> {{ $report->created_at->format('Y-m-d H:i') }}</p>
            <hr>
            <p style="white-space: pre-line;">{{ $report->message }}</p>
        </div>

        @if(is_null($report->resolved))
            <form method="POST" action="{{ route('admin.reporting.resolve', $report->id) }}" style="padding:1rem; display:flex; gap:.5rem;">
                @csrf
                @method('PUT')
                <div class="form-grid">
                    <div class="form-field">
                        <button type="submit" class="btn success">{{ __('Mark as resolved') }}</button>
                    </div>
                    <div class="form-field">
                        <a href="{{ route('admin.reporting.index') }}" class="btn ghost">{{ __('Close') }}</a>
                    </div>
                </div>
            </form>
        @else
            <div class="form-grid">
                <div class="form-field">
                    <div class="alert success" style="margin:1rem;">
                        {{ __('Resolved on') }} {{ $report->resolved->format('Y-m-d H:i') }}
                    </div>
                </div>
                <div class="form-field">
                   <div style="padding:1rem;">
                        <a href="{{ route('admin.reporting.index') }}" class="btn ghost">{{ __('Close') }}</a>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection