@extends('layouts.base')

@section('title', 'Admin · ' . ($society->name))

@section('content')
    <div class="wrap">
        <h2 style="margin-bottom:12px;">{{ __('Edit society') }} — {{ $society->name }}</h2>

        @if(session('ok')) <div class="ok">{{ session('ok') }}</div> @endif
        @if($errors->any())
            <div class="alert danger">
                <ul style="margin:6px 0 0 16px;">
                    @foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach
                </ul>
            </div>
        @endif

        <div class="card" style="margin-bottom:16px;">
            <form method="POST" action="{{ route('admin.societies.update', $society) }}" enctype="multipart/form-data">
                @csrf 
                @method('PUT')

                <div class="card" style="max-width:980px;">
                    <div class="card-header">
                        <div class="title">{{ $society->name ?? __('Company') }}</div>
                    </div>

                    <div class="card-body">

                        {{-- Identity --}}
                        <div class="form-field">
                            <label for="name">{{ __('Name') }}</label>
                            <input id="name" type="text" name="name" required
                                value="{{ old('name', $society->name) }}">
                        </div>

                        {{-- Address --}}
                        <div class="form-grid">
                            <div class="form-field">
                                <label for="street">{{ __('Street') }}</label>
                                <input id="street" type="text" name="street"
                                    value="{{ old('street', $society->street) }}">
                            </div>
                        </div>

                        <div class="form-grid">
                            <div class="form-field">
                                <label for="postcode">{{ __('Postcode') }}</label>
                                <input id="postcode" type="text" name="postcode"
                                    value="{{ old('postcode', $society->postcode) }}">
                            </div>
                            <div class="form-field">
                                <label for="city">{{ __('City') }}</label>
                                <input id="city" type="text" name="city"
                                    value="{{ old('city', $society->city) }}">
                            </div>
                            <div class="form-field">
                                <label for="country">{{ __('Country') }}</label>
                                <input id="country" type="text" name="country"
                                    value="{{ old('country', $society->country) }}">
                            </div>
                        </div>

                        {{-- Contact --}}
                        <div class="form-grid">
                            <div class="form-field">
                                <label for="phone">{{ __('Phone') }}</label>
                                <input id="phone" type="text" name="phone"
                                    value="{{ old('phone', $society->phone) }}">
                            </div>
                            <div class="form-field">
                                <label for="email">{{ __('Email') }}</label>
                                <input id="email" type="email" name="email"
                                    value="{{ old('email', $society->email) }}">
                            </div>
                        </div>

                        {{-- Subscription date --}}
                        {{-- <div class="form-field">
                            <label for="subscribed_at">{{ __('Subscribed at') }}</label>
                            <input id="subscribed_at" type="date" name="subscribed_at"
                                value="{{ old('subscribed_at', optional($society->subscribed_at)->format('Y-m-d')) }}">
                        </div> --}}

                        {{-- Logo / Photo --}}
                        <div class="form-field">
                            <label>{{ __('Logo / Photo') }}</label>

                            @if(!empty($society->photo))
                                <div style="margin:8px 0">
                                    <img src="{{ Storage::url($society->photo) }}" alt="Logo" style="max-height:120px;border-radius:8px">
                                </div>
                                <label style="display:flex;align-items:center;gap:.5rem;">
                                    <input type="checkbox" name="remove_photo" value="1">
                                    <span>{{ __('Remove current image') }}</span>
                                </label>
                            @endif

                            <input type="file" name="photo" accept="image/*">
                            <small class="muted">{{ __('PNG/JPG up to 4MB') }}</small>
                        </div>

                        {{-- Read-only meta (optional) --}}
                        {{-- <div class="form-grid" style="margin-top:12px; opacity:.8;">
                            <div class="form-field">
                                <label>{{ __('Created at') }}</label>
                                <input type="text" value="{{ $society->created_at }}" readonly>
                            </div>
                            <div class="form-field">
                                <label>{{ __('Updated at') }}</label>
                                <input type="text" value="{{ $society->updated_at }}" readonly>
                            </div>
                        </div> --}}

                        {{-- Actions --}}
                        <div class="actions" style="margin-top:16px;">
                                <a class="btn ghost" href="{{ route('admin.societies.index') }}">{{ __('Cancel') }}</a>
                                <button class="btn primary" type="submit">{{ __('Save') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="card">
            <h3 style="margin:0 0 8px;">{{ __('Admin Pro assignment') }}</h3>

            @php
                /** @var \App\Models\Society $society */
                $adminPros = $adminPros ?? collect();
                $adminPro  = $adminPro  ?? $adminPros->first();
                $proUsers  = $proUsers  ?? collect();

                $current = $currentAdminProId
                    ? $adminPros->firstWhere('id', $currentAdminProId)
                    : null;
            @endphp

            {{-- <p style="color:#6b7280; margin: 0 0 12px;">
                {{ __('Each society can have exactly one Admin Pro (role_id = 2). An Admin Pro can be linked to only one society.') }}
            </p> --}}

            <form method="POST" action="{{ route('admin.societies.assignAdminPro', $society) }}">
                @csrf
                {{-- <label for="user_id">{{ __('Admin Pro') }}</label> --}}
                <select id="user_id" name="user_id" required>
                    <option value="">{{ __('Select an Admin Pro') }}</option>
                    @foreach($adminPros as $u)
                        <option value="{{ $u->id }}" {{ (int)$u->id === (int)$currentAdminProId ? 'selected':'' }}>
                            {{ $u->lastname }} {{ $u->firstname }} — {{ $u->email }}
                        </option>
                    @endforeach
                </select>

                <div class="actions" style="margin-top:12px;">
                    <button type="submit" class="btn primary">{{ __('Assign') }}</button>
                </div>
            </form>
        </div>

    </div>
@endsection