@extends('layouts.base')

@section('title','Admin · Sociétés')

@section('content')
<div class="wrap">
    <h2 style="margin-bottom:12px;">{{ __('Societies') }}</h2>

    <form method="GET" action="{{ route('admin.societies.index') }}" class="filters" style="margin-bottom:12px;">
        <input type="text" name="q" value="{{ $q }}" placeholder="{{ __('Search') }}…">
        <button class="btn small ghost" type="submit">{{ __('Filter') }}</button>
        <a class="btn small ghost" href="{{ route('admin.societies.index') }}">{{ __('Reset') }}</a>
    </form>

    @if(session('ok')) <div class="ok">{{ session('ok') }}</div> @endif

    <div class="card">
        <table class="table">
            <thead>
                <tr>
                    <th>{{ __('Name') }}</th>
                    <th>{{ __('Admin Pro') }}</th>
                    <th style="width:220px">{{ __('Actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($societies as $s)
                    @php
                        $admin = $s->adminPros()->first();
                    @endphp
                    <tr>
                        <td>{{ $s->name }}</td>
                        <td>
                            @if($admin)
                                {{ $admin->firstname }} {{ $admin->lastname }} — {{ $admin->email }}
                            @else
                                <em>{{ __('None') }}</em>
                            @endif
                        </td>
                        <td>
                            <a class="btn small ghost" href="{{ route('admin.societies.edit', $s) }}">{{ __('Edit') }}</a>
                            <form method="POST" action="{{ route('admin.societies.destroy', $s) }}"
                                  style="display:inline" onsubmit="return confirm('{{ __('Delete this society') }} ?')">
                                @csrf @method('DELETE')
                                <button class="btn small danger" type="submit">{{ __('Delete') }}</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="3">{{ __('No society found') }}</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top:12px;">{{ $societies->withQueryString()->links() }}</div>
</div>
@endsection