{{-- resources/views/admin/users/edit.blade.php --}}


@php
    /** File: resources/views/admin/users/edit.blade.php */
    // Fallback si la variable n'a pas été passée par le contrôleur
    if (!isset($selectedSocietyIds)) {
        try {
            $selectedSocietyIds = isset($user)
                ? $user->societies()->pluck('societydb.id')->toArray()
                : [];
        } catch (\Throwable $e) {
            $selectedSocietyIds = [];
        }
    }
    // S'assurer que c'est bien un array
    if ($selectedSocietyIds instanceof \Illuminate\Support\Collection) {
        $selectedSocietyIds = $selectedSocietyIds->toArray();
    }
@endphp


@extends('layouts.base')

@section('title', 'Admin · ' . __('Edit user'))

@section('content')


{{-- <option value="{{ $s->id }}"
  {{ in_array($s->id, $selectedSocietyIds ?? [], true) ? 'selected' : '' }}>
  {{ $s->name }}
</option> --}}


    <div class="wrap" style="max-width:960px">
        @if(session('ok'))
            <div class="ok">{{ session('ok') }}</div>
        @endif
        @if($errors->any())
            <div class="alert danger" style="margin-bottom:12px">
            <strong>{{ __('Please correct the errors below') }}</strong>
            <ul style="margin:6px 0 0 18px">
                @foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach
            </ul>
            </div>
        @endif

        <h1 class="title" style="margin-bottom:18px">
            {{ __('Edit user') }} #{{ $user->id }} {{ $user->name }}
        </h1>

        <form method="POST" action="{{ route('admin.users.update', $user) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            {{-- Carte principale --}}
            <div style="display:grid; gap:16px; grid-template-columns: 1.2fr .8fr;">
            {{-- Colonne gauche : infos compte --}}
            <div class="card" style="padding:16px; border-radius:12px; border:1px solid #e5e7eb; background:#fff;">
                <h2 style="font-size:18px; font-weight:700; margin-bottom:12px">{{ __('Account') }}</h2>

   
 
                <div class="grid-2" style="display:grid; grid-template-columns:1fr 1fr; gap:10px;">
                    <div class="field">
                        <label>{{ __('Lastname') }} *</label>
                        <input type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}" required>
                        <label>{{ __('Firstname') }} *</label>
                        <input type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}" required>
                    </div>
                    <div class="field">
                        <label>{{ __('Address 1') }}</label>
                        <input type="text" name="address1" value="{{ old('address1', $user->address1) }}">
                    </div>
                    <div class="field">
                        <label>{{ __('Address 2') }}</label>
                        <input type="text" name="address2" value="{{ old('address2', $user->address2) }}">
                    </div>
                    <div class="field">
                        <label>{{ __('Postcode') }}</label>
                        <input type="text" name="postcode" value="{{ old('postcode', $user->postcode) }}">
                    </div>
                    <div class="field">
                        <label>{{ __('City') }}</label>
                        <input type="text" name="city" value="{{ old('city', $user->city) }}">
                    </div>
                    <div class="field">
                        <label>{{ __('Country code') }}</label>
                        <input type="text" name="country_isocode" maxlength="3" value="{{ old('country_isocode', $user->country_isocode) }}">
                    </div>
                    <div class="form-field" style="margin-top:1rem;">
                            {{-- Blocked --}}
                            <label style="display:flex; gap:.5rem; align-items:center; margin-top:1rem;">
                            <input type="checkbox" name="set_blocked" value="1" {{ $user->blocked ? 'checked' : '' }}>
                            <span>Blocked (prevent login)</span>
                        </label>

                        @if($user->blocked)
                            <div style="color:#6b7280; font-size:.9em;">
                            {{ __('Blocked since') }}: {{ $user->blocked->format('Y-m-d H:i') }}
                            </div>
                        @endif
                    </div>
                </div>

                 <div class="field">
                    <label>{{ __('Email') }} *</label>
                    <input type="email" name="email" value="{{ old('email', $user->email) }}" required>
                    <div style="font-size:.85rem; color:#6b7280; margin-top:4px">
                        {{ __('Email can be changed; verification may be required.') }}
                    </div>
                </div>

              <div class="field">
                    <label>{{ __('Password (leave blank to keep)') }}</label>
                    <input type="password" name="password" placeholder="••••••••">
                </div>
            </div>

            {{-- Colonne droite : avatar / rôle / sociétés --}}
            <div class="card" style="padding:16px; border-radius:12px; border:1px solid #e5e7eb; background:#fff;">

                {{-- Avatar --}}
                <h2 style="font-size:18px; font-weight:700; margin-bottom:12px">{{ __('Profile picture') }}</h2>
                <div class="field" style="display:flex; align-items:center; gap:12px">
                    <div>
                        @if($user->photo)
                        <img src="{{ Storage::url($user->photo) }}" alt="Avatar" style="width:96px; height:96px; border-radius:12px; object-fit:cover; border:1px solid #e5e7eb;">
                        @else
                        <div style="width:96px; height:96px; border-radius:12px; background:#f3f4f6; display:flex; align-items:center; justify-content:center; color:#9ca3af; border:1px solid #e5e7eb;">
                            {{ __('No photo') }}
                        </div>
                        @endif
                    </div>
                    <div>
                        <input type="file" name="photo" accept="image/*">
                        <div style="font-size:.85rem; color:#6b7280; margin-top:4px">
                            {{ __('PNG/JPG up to 2 MB') }}
                        </div>
                    </div>
                </div>

                <hr style="border:none; border-top:1px solid #e5e7eb; margin:16px 0">

                {{-- Rôle (existant) --}}
                <label for="role_id" class="form-label">{{ __('Role') }}</label>
                <select id="role_id" name="role_id" class="form-select" required>
                    @php
                        $currentRoleId = old('role_id', $user->role_id);
                    @endphp
                    @foreach($roles as $r)
                        <option value="{{ $r->id }}" {{ (int)$currentRoleId === (int)$r->id ? 'selected' : '' }}>
                            {{ $r->name }}
                        </option>
                    @endforeach
                </select>
                @error('role_id')
                    <div class="invalid-feedback" style="display:block">{{ $message }}</div>
                @enderror

                {{-- Sociétés (multi) --}}
                @php
                    $societies = $societies ?? collect();
                    $selectedSocietyIds = $selectedSocietyIds ?? [];
                @endphp

                <label class="form-label" style="margin-top:1rem;">{{ __('Societies') }}</label>
                @if($societies->isEmpty())
                    <div class="text-muted" style="font-size:.9rem;">(Aucune société disponible)</div>
                @else
                    {{-- <label for="societies">Sociétés</label> --}}
                    <select id="societies" name="societies[]" multiple>
                        @foreach($societies as $s)
                            <option value="{{ $s->id }}" 
                                {{ in_array($s->id, $selectedSocietyIds, true) ? 'selected' : '' }}>
                                {{ $s->name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="text-muted" style="font-size:.85rem">Maintenir Ctrl/⌘ pour multi-sélection.</div>
                    <input type="hidden" name="societies[]" value="">
                @endif


            </div>
    
            <div style="display:flex; gap:8px; margin-top:16px;">
                <button type="submit" class="btn primary">{{ __('Save') }}</button>
                <a class="btn ghost" href="{{ route('admin.users.index') }}">{{ __('Cancel') }}</a>
            </div>
        </form>
    </div>
@endsection