{{-- resources/views/admin/users/import.blade.php --}}
@extends('layouts.base')

@section('title', __('Import users (CSV)'))

@section('content')
<div class="wrap">
  <h2 style="margin:0 0 12px;">{{ __('Import users (CSV)') }}</h2>

  @if(session('ok'))
    <div class="ok">{{ session('ok') }}</div>
  @endif

  @if($errors->any())
    <div class="alert danger">
      <ul style="margin:0 0 0 16px;">
        @foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach
      </ul>
    </div>
  @endif

  @if(session('import_errors'))
    <details class="card" style="margin-bottom:12px;">
      <summary class="card-header">{{ __('Row errors') }} ({{ count(session('import_errors')) }})</summary>
      <div class="card-body">
        <ul style="margin:0 0 0 16px;">
          @foreach(session('import_errors') as $e)
            <li>{{ $e }}</li>
          @endforeach
        </ul>
      </div>
    </details>
  @endif

  <div class="card" style="max-width:780px;">
    <div class="card-body">
      <form method="POST" action="{{ route('admin.users.import.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="form-field">
          <label for="file">{{ __('CSV file') }}</label>
          <input id="file" type="file" name="file" accept=".csv,text/csv" required>
          <small class="muted">
            {{ __('Expected columns (header, case-insensitive):') }}
            <code>firstname, lastname, email, password, phone, address1, address2, postcode, city, country_isocode, role_id, society_id</code>
          </small>
        </div>

        <div class="form-grid">
          <label class="chk">
            <input type="checkbox" name="has_header" value="1" checked>
            <span>{{ __('First row is header') }}</span>
          </label>

          <div class="form-field">
            <label for="mode">{{ __('On duplicate email') }}</label>
            <select id="mode" name="mode">
              <option value="skip">{{ __('Skip existing') }}</option>
              <option value="update">{{ __('Update existing') }}</option>
            </select>
          </div>

          <div class="form-field">
            <label for="force_society_id">{{ __('Force company for all rows (optional)') }}</label>
            <input id="force_society_id" type="number" name="force_society_id" placeholder="{{ __('society_id') }}">
            <small class="muted">{{ __('Overrides society_id column if provided.') }}</small>
          </div>
        </div>

        <div class="actions" style="margin-top:12px;">
          <button class="btn primary" type="submit">{{ __('Import') }}</button>
        </div>
      </form>
    </div>
  </div>

  <details class="card" style="margin-top:12px;">
    <summary class="card-header">{{ __('CSV example') }}</summary>
    <div class="card-body">
<pre style="white-space:pre-wrap; margin:0;">
firstname,lastname,email,password,phone,address1,address2,postcode,city,country_isocode,role_id,society_id
Alice,Durand,alice@example.com,,0600000001,10 Rue A,,75001,Paris,FR,4,1
Bob,Martin,bob@example.com,Secret123,0600000002,20 Rue B,,69001,Lyon,FR,4,1
</pre>
      <small class="muted">
        {{ __('If password is empty, a random password will be generated. New users will receive a verification email.') }}
      </small>
    </div>
  </details>
</div>
@endsection