@extends('layouts.base')

@section('title', 'Admin · Users')

@section('content')
    <div class="wrap" style="padding:20px 0">
        <h1 style="margin:0 0 12px">{{ __('Users') }}</h1>


         @if(session('ok'))
            <div style="background:#ecfdf5;border:1px solid #10b98133;padding:10px;border-radius:8px;margin-bottom:12px">
                {{ session('ok') }}
            </div>
        @endif


        {{-- Actions header: search + Import CSV + Society dropdown --}}
        <div class="" style="align-items:center; gap:12px; margin-bottom:12px;">
            <div class="form-grid">
                <div class="form-field">
                    {{-- Left: search --}}
                    <form method="GET" action="{{ route('admin.users.index') }}" class="flex" style="gap:8px; align-items:center;">
                        <input type="text" name="q" value="{{ $q ?? '' }}" placeholder="{{ __('Search…') }}" />
                        @if($societyId)
                            <input type="hidden" name="society_id" value="{{ $societyId }}">
                        @endif
                        <button class="btn small ghost">{{ __('Filter') }}</button>
                    </form>
                </div>
                {{-- Right: Import + Society filter dropdown --}}
                <div class="form-field">
                    <div class="form-grid">
                        <div class="form-field">
                            <a class="btn small ghost" style="margin-top: 16px;" href="{{ route('admin.users.import.form') }}">{{ __('Import CSV') }}</a>

                         </div>
                        <div class="form-field">
                            {{-- Society filter dropdown (auto-submit on change) --}}
                            <form method="GET" action="{{ route('admin.users.index') }}" class="" style="gap:6px; align-items:center;">
                                @if($q !== '')
                                    <input type="hidden" name="q" value="{{ $q }}">
                                @endif

                                {{-- <label for="society_id" class="muted" style="margin-right:4px;">{{ __('Company') }}</label> --}}
                                <select id="society_id" name="society_id" onchange="this.form.submit()">
                                    <option value="">{{ __('All users') }}</option>
                                    @forelse($societies as $s)
                                        <option value="{{ $s->id }}" {{ (int)$societyId === (int)$s->id ? 'selected' : '' }}>
                                            {{ $s->name }} ({{ $s->users_count }})
                                        </option>
                                    @empty
                                        <option value="">{{ __('No company available') }}</option>
                                    @endforelse
                                </select>
                               {{-- @if($societyId)
                                    <a class="btn small ghost"
                                    href="{{ route('admin.users.index', ['q'=>$q]) }}"
                                    title="{{ __('Show all users') }}">
                                        {{ __('Reset') }}
                                    </a>
                                @endif --}}
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div style="overflow:auto;border:1px solid #e5e7eb;border-radius:10px;background:#fff">
            <table style="width:100%;border-collapse:collapse;font-size:14px">
                <thead style="background:#f8fafc">
                    <tr>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">ID</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">{{ __('Lastname') }}</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">{{ __('Firstname') }}</th>
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">{{ __('Role') }}</th> 
                        <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb">{{ __('Companies') }}</th>
                        <th style="text-align:right;padding:8px;border-bottom:1px solid #e5e7eb">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($users as $user)
                    <tr>
                        <td style="padding:8px;border-bottom:1px solid #f1f5f9">{{ $user->id }}</td>
                        <td style="padding:8px;border-bottom:1px solid #f1f5f9">{{ $user->lastname }}</td>
                        <td style="padding:8px;border-bottom:1px solid #f1f5f9">{{ $user->firstname }}</td>
                        <td>{{ optional($user->role)->name ?? '—' }}</td>

                        {{-- ✅ Sociétés associées --}}
                        <td>
                            @php
                                $societies = $user->societies ?? collect();
                            @endphp

                            @if($societies->isEmpty())
                                <span class="muted">—</span>
                            @else
                                <div style="display:flex; flex-wrap:wrap; gap:6px;">
                                    @foreach($societies as $s)
                                        <span class="badge" style="display:inline-block; padding:.15rem .5rem; border:1px solid var(--border-color,#2a2f3a); border-radius:999px; font-size:.85em;">
                                            {{ $s->name }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif
                        </td>

                        {{-- <td style="padding:8px;border-bottom:1px solid #f1f5f9">{{ optional($user->created_at)->format('Y-m-d H:i') }}</td> --}}
                        <td style="padding:8px;border-bottom:1px solid #f1f5f9;text-align:right">
                            {{-- <a href="{{ route('admin.users.show', $user) }}" class="btn small ghost" style="margin-right:6px">{{ __('View') }}</a> --}}
                            <a href="{{ route('admin.users.edit', ['locale'=>app()->getLocale(), 'user'=>$user]) }}" class="btn small ghost">{{ __('Edit') }}</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="padding:12px;text-align:center">{{ __('No users found') }}</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        @if(method_exists($users, 'links'))
            <div style="margin-top:16px">{{ $users->links() }}</div>
        @endif

        {{ $users->appends(['q'=>$q, 'society_id'=>$societyId])->links() }}
    </div>
@endsection
