@extends('layouts.base')

@section('title', 'Admin · User #'.$user->id)

@section('content')
    <div class="wrap" style="padding:20px 0">
        <a href="{{ route('admin.users.index') }}" class="btn" style="margin-bottom:12px;display:inline-flex;align-items:center;gap:6px">
            &larr; {{ __('Back to users') }}
        </a>

        <h1 style="margin:0 0 16px">{{ __('User #:id', ['id' => $user->id]) }} · {{ $user->name }}</h1>

        <div style="border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff;max-width:540px">
            <dl style="margin:0;display:grid;grid-template-columns:max-content 1fr;row-gap:8px;column-gap:16px">
                <dt style="font-weight:600;color:#4b5563">ID</dt>
                <dd style="margin:0">{{ $user->id }}</dd>

                <dt style="font-weight:600;color:#4b5563">{{ __('Name') }}</dt>
                <dd style="margin:0">{{ $user->name ?? '—' }}</dd>

                <dt style="font-weight:600;color:#4b5563">{{ __('Email') }}</dt>
                <dd style="margin:0">{{ $user->email ?? '—' }}</dd>

                <dt style="font-weight:600;color:#4b5563">{{ __('Created at') }}</dt>
                <dd style="margin:0">{{ optional($user->created_at)->format('Y-m-d H:i') ?? '—' }}</dd>

                <dt style="font-weight:600;color:#4b5563">{{ __('Updated at') }}</dt>
                <dd style="margin:0">{{ optional($user->updated_at)->format('Y-m-d H:i') ?? '—' }}</dd>

                <dt style="font-weight:600;color:#4b5563">{{ __('Status') }}</dt>
                <dd style="margin:0">
                    @if(method_exists($user, 'isActive') ? $user->isActive() : true)
                        <span style="color:#16a34a">{{ __('Active') }}</span>
                    @else
                        <span style="color:#dc2626">{{ __('Inactive') }}</span>
                    @endif
                </dd>
            </dl>
        </div>

        <div style="margin-top:16px;display:flex;gap:10px;flex-wrap:wrap">
            <a href="{{ route('admin.users.edit', $user) }}" class="btn">{{ __('Edit user') }}</a>
        </div>
    </div>
@endsection
