@extends('layouts.base')

@section('title', __('Reset password'))

@section('content')

    <div class="wrap" style="max-width:420px; margin-inline:auto;">
        <h2>{{ __('Forgot your password?') }}</h2>
        <p class="muted">{{ __('Enter your email and we will send you a password reset link.') }}</p>

        @if(session('status'))
            <div class="ok">{{ session('status') }}</div>
            <a class="btn small danger" style="width:100%;text-align:left" href="{{ lr('login') }}">{{ __('Log in') }}</a>
                 
        @else
            <form method="POST" action="{{ route('password.email') }}">
                @csrf
                <div class="form-field">
                    <label for="email">{{ __('Email') }}</label>
                    <input id="email" type="email" name="email" required autofocus value="{{ old('email') }}">
                </div>

                <div class="actions" style="margin-top:12px;">
                    <button type="submit" class="btn primary">{{ __('Send password reset link') }}</button>
                </div>
            </form>
        @endif
   </div>
@endsection