@extends('layouts.base')

@section('title', __('Reset password'))

@section('content')
<div class="wrap" style="max-width:420px; margin-inline:auto;">
  <h2>{{ __('Reset password') }}</h2>

  @if($errors->any())
    <div class="alert danger">
      <ul style="margin:0 0 0 16px;">
        @foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach
      </ul>
    </div>
  @endif

  <form method="POST" action="{{ route('password.update') }}">
        @csrf
        <input type="hidden" name="token" value="{{ $token }}">
        <input type="hidden" name="email" value="{{ $email }}">

        <div class="form-field">
            <label for="password">{{ __('New password') }}</label>
            <input id="password" type="password" name="password" required autofocus>
        </div>

        <div class="form-field">
            <label for="password_confirmation">{{ __('Confirm password') }}</label>
            <input id="password_confirmation" type="password" name="password_confirmation" required>
        </div>

        <div class="actions" style="margin-top:12px;">
            <button type="submit" class="btn primary">{{ __('Reset password') }}</button>
        </div>
  </form>
</div>
@endsection