{{-- resources/views/auth/verify-email.blade.php --}}
@extends('layouts.base')

@section('title', __('Verify your email'))

@section('content')
<div class="wrap">
    @if(session('ok'))
        <div class="ok">{{ session('ok') }}</div>
    @endif

    <div class="card" style="max-width:720px; margin-inline:auto;">
        <div class="card-body">
            <h2 style="margin:0 0 8px;">{{ __('Verify your email') }}</h2>
            <p style="color:#a7acb4">
                {{ __('We have sent a verification link to your email address. Please click the link to activate your account.') }}
            </p>

            <form method="POST" action="{{ route('verification.send', ['locale'=>app()->getLocale()]) }}" style="margin-top:12px;">
                @csrf
                <button class="btn small ghost" type="submit">{{ __('Resend verification email') }}</button>
            </form>

            <div style="margin-top:12px;">
                <a class="btn small" href="{{ lr('logout') }}"
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    {{ __('Logout') }}
                </a>
                <form id="logout-form" action="{{ lr('logout') }}" method="POST" style="display:none;">
                    @csrf
                </form>
            </div>
        </div>
    </div>
</div>
@endsection