{{-- resources/views/emails/points/share.blade.php --}}
@php
  /** @var \App\Models\Point $point */
  $titleName = $recipientName ?: $recipientEmail;
 
@endphp

<p>Hello {{ $titleName }},</p>

<p>
  {{ $ownerName }} {{ $ownerEmail ? "({$ownerEmail})" : '' }} has shared a waypoint with you:
  <strong>{{ $point->name }}</strong>
</p>

@if(!empty($point->address1) || !empty($point->city) || !empty($point->postcode) || !empty($point->country_isocode))
  <p style="margin:0 0 8px 0;">
    {{ trim(($point->address1 ?? '').' '.($point->address2 ?? '')) }}<br>
    {{ trim(($point->postcode ?? '').' '.($point->city ?? '')) }} {{ $point->country_isocode }}
  </p>
@endif

<p>
  {{ __('Open the waypoint:') }}
  <a href="{{ $url }}" target="_blank" rel="noopener">{{ $url }}</a>
</p>

@if(isset($sharing) && ($sharing?->start_at || $sharing?->end_at))
  <p>
    {{ __('Access window') }}:
    @if($sharing?->start_at) {{ __('from') }} {{ \Illuminate\Support\Carbon::parse($sharing->start_at)->format('Y-m-d H:i') }} @endif
    @if($sharing?->end_at)   {{ __('to') }}   {{ \Illuminate\Support\Carbon::parse($sharing->end_at)->format('Y-m-d H:i') }}   @endif
  </p>
@endif

<p>— {{ config('app.name') }}</p>