{{-- resources/views/itins/index.blade.php --}}
@extends('layouts.base')

@section('title', __('Itineraries'))

@section('content')
@php
use Illuminate\Support\Facades\Route;

$routeName = Route::currentRouteName();
$isAdminNs = str_starts_with($routeName, 'admin.');
$locale    = app()->getLocale();

// Safe route builders
$createUrl = function() use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.create')) {
        return route('admin.itins.create');
    }
    if (!$isAdminNs && Route::has('pro.itins.create')) {
        return route('pro.itins.create', ['locale'=>$locale]);
    }
    return '#';
};

$editUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.edit')) {
        return route('admin.itins.edit', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.edit')) {
        return route('pro.itins.edit', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    return '#';
};

$destroyUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.destroy')) {
        return route('admin.itins.destroy', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.destroy')) {
        return route('pro.itins.destroy', ['locale'=>$locale, 'itinerary'=>$it->id]);
    }
    return '#';
};

$updateUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.update')) {
        return route('admin.itins.update', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.destroy')) {
        return route('pro.itins.update', ['locale'=>app()->getLocale(), 'itinerary'=>$itinerary->id]);
    }
    return '#';
};

$mapUrl = function($it) use ($isAdminNs, $locale) {
    if ($isAdminNs && Route::has('admin.itins.map')) {
        return route('admin.itins.map', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]);
    }
    if (!$isAdminNs && Route::has('pro.itins.map')) {
        return route('pro.itins.map', ['locale'=>$locale, 'itinerary'=>$it->id]);
    }
    return '#';
};
@endphp

<style>
    table { width:100%; border-collapse:collapse; margin-top:12px; }
    th, td { padding:10px 12px; border-bottom:1px solid var(--border-color,#252935); text-align:left; }
    th { background:#0c0e17; font-weight:600; }
    tr:hover td { border-bottom:1px solid var(--border-color,#252935);}
    .actions { display:flex; flex-wrap:wrap; gap:6px; }
    .muted { color:#a0a6af; font-size:0.9em; }
    .btn.small { padding:4px 10px; font-size:0.85em; }
    .wrap { max-width:1200px; margin:auto; }
</style>

<div class="wrap">
    <h2 style="margin:0 0 12px;">{{ __('Itineraries') }}</h2>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif

    <div style="margin-bottom:14px;">
        <a href="{{ $createUrl() }}" class="btn primary">+ {{ __('Create an itinerary') }}</a>
    </div>

    @if($itineraries->isEmpty())
        <div class="muted">{{ __('No itineraries found.') }}</div>
    @else
        <table>
            <thead>
                <tr>
                    <th style="width:40px;">#</th>
                    <th>{{ __('Name') }}</th>
                    <th>{{ __('Company') }}</th>
                    <th>{{ __('Pro admin') }}</th>
                    <th>{{ __('Users assigned') }}</th>
                    <th style="width:210px;">{{ __('Actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($itineraries as $it)
                    <tr>
                        <td>{{ $it->id }}</td>
                        <td>{{ $it->name }}</td>
                        <td>{{ $it->society->name ?? '—' }}</td>
                        <td>
                            @if($it->assignedAdmin)
                                {{ $it->assignedAdmin->firstname }} {{ $it->assignedAdmin->lastname }}
                            @else
                                <span class="muted">—</span>
                            @endif
                        </td>
                        <td>
                            @if($it->assignedUsers && $it->assignedUsers->count())
                                <span title="{{ $it->assignedUsers->pluck('firstname')->join(', ') }}">
                                    {{ $it->assignedUsers->count() }}
                                </span>
                            @else
                                <span class="muted">0</span>
                            @endif
                        </td>
                        <td>
                            <div class="actions">
                                <a class="btn small" href="{{ $editUrl($it) }}">{{ __('Edit') }}</a>
                               <a class="btn small ghost" href="{{ $mapUrl($it) }}">{{ __('Map') }}</a>
     
                                <form method="POST" action="{{ $destroyUrl($it) }}" style="display:inline;" onsubmit="return confirm('{{ __('Delete this itinerary?') }}');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn small danger">{{ __('Delete') }}</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        @if(method_exists($itineraries, 'links'))
            <div style="margin-top:16px;">
                {{ $itineraries->links() }}
            </div>
        @endif
    @endif
</div>
@endsection