{{-- resources/views/itins/mine.blade.php --}}
@extends('layouts.base')

@section('title', __('My itineraries'))

@section('content')
<div class="wrap">
  <h2 style="margin:0 0 12px;">{{ __('My itineraries') }}</h2>

  @if(session('ok'))
    <div class="ok">{{ session('ok') }}</div>
  @endif

  @if($itins->isEmpty())
    <div class="alert">{{ __('No itinerary assigned to your account yet.') }}</div>
  @else
    <div class="card">
      <div class="card-body" style="overflow:auto">
        <table class="table">
          <thead>
            <tr>
              <th>{{ __('Name') }}</th>
              <th>{{ __('Scheduled date') }}</th>
              {{-- <th>{{ __('Company') }}</th> --}}
              <th>{{ __('Owner') }}</th>
              <th>{{ __('Points') }}</th>
              {{-- <th>{{ __('Next arrival') }}</th> --}}
              <th></th>
            </tr>
          </thead>
          <tbody>
          @foreach($itins as $it)
            <tr>
              <td>{{ $it->name }}</td>
              <td>
                {{ $it->scheduled_date
                    ? localized_date($it->scheduled_date)
                    : '—' }}
              </td>
              {{-- <td>{{ $it->society->name ?? '—' }}</td> --}}
              <td>
                @php $o = $it->owner; @endphp
                {{ $o ? trim(($o->firstname ?? '').' '.($o->lastname ?? '')) : '—' }}
              </td>
              <td>{{ $it->points_count ?? $it->points()->count() }}</td>
              {{-- <td>
                @if(!empty($it->next_arrival_at))
                  {{-- {{ \Illuminate\Support\Carbon::parse($it->next_arrival_at)->format('Y-m-d H:i') }} --}}
                  {{-- {{ localized_date($it->next_arrival_at) }}
                @else
                  —
                @endif 
              </td> --}}
              <td style="text-align:right;">
                <a class="btn small"
                   href="{{ route('itins.user.map', ['locale'=>app()->getLocale(), 'itinerary'=>$it->id]) }}">
                  {{ __('Map') }}
                </a>
              </td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
    </div>
  @endif
</div>
@endsection