<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>@yield('title', config('app.name','Laravel'))</title>
        @vite(['resources/css/app.css','resources/js/app.js'])

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
 
         <link rel="stylesheet" href="/assets/css/global.css">
        <link rel="stylesheet" href="/assets/css/vereego.css">

   </head>
    @stack('scripts')
    <body class="antialiased">
        <header class="nav">
            <div class="wrap nav-row" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
                {{-- Logo on the left --}}
                <a class="brand" href="{{ lr('welcome') }}" style="display:inline-flex;align-items:center;gap:8px">
                    <img src="/assets/images/Logo_Vereego_500.png" alt="Vereego" style="height:38px;width:auto">
                    <span></span>
                </a>

                {{-- Buttons on the right --}}
                @php
                    $onHome   = request()->routeIs('welcome');
                    $onMap    = request()->routeIs('map');
                    $onSearch = request()->routeIs('search');
                @endphp


            @unless($onHome)
                    <a class="btn small ghost"  href="{{ lr('welcome') }}" style="display:inline-flex;align-items:center;gap:8px">
                        {{ __('Home') }}
                    </a>
                @endunless

    
                {{-- Page-specific links on the left (optional) --}}
                <nav class="nav-left" style="display:flex;gap:8px;align-items:center">
                    @stack('nav.left')  {{-- << pages can push items here --}}
                </nav>

                <nav style="display:flex;gap:12px;align-items:center">
    
                    {{-- Space for extra actions on the right (optional) --}}
                    @stack('nav.right')



                    {{-- User menu / authentication --}}
                    {{-- If signed in, show the user dropdown --}}
                    {{-- If signed out, display the login / register links --}}
                    {{-- If admin, show the admin link --}}
                    @auth
                        {{-- Show “New waypoint” except on /map --}}
   
                        {{-- Show “My waypoints” except on /search --}}
 
                        @php
                            // to avoid a heavy query everywhere, we test "exists()" when we can
                            $hasItins = optional(auth()->user()->itinerariesAssigned()->limit(1)->pluck('itineraries.id'))->isNotEmpty();
                        @endphp
 
                        <div class="dropdown admin-dropdown">
                            <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                {{ __('Waypoints') }} ▾
                            </button>
                            <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                @unless($onMap)
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small primary" href="{{ lr('map') }}">{{ __('New waypoint') }}</a>
                                @endunless
                                @unless($onSearch)
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small ghost" href="{{ lr('search') }}">{{ __('My waypoints') }}</a>
                                @endunless
                                @if($hasItins)
                                    <a style="margin:6px 0 0; width: 100%;" class="btn small ghost" href="{{ route('itins.mine', ['locale'=>app()->getLocale()]) }}" class="{{ request()->routeIs('itins.mine') ? 'active' : '' }}">
                                        {{ __('Itineraries') }}
                                    </a>
                                @endif
                            </div>
                        </div>

   

                        @php
                            $u = Auth::user();
                            $isSuper = $u && (((int)($u->role_id ?? 0) === 1) || strcasecmp(optional($u->role)->name ?? '', 'Admin') === 0);
                        @endphp
                        @if($isSuper && Route::has('admin.points.index'))
                            <div class="dropdown admin-dropdown">
                                <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                    {{ __('Admin') }} ▾
                                </button>
                                <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                    <a class="dropdown-item btn small ghost" href="{{ route('admin.points.index') }}">
                                        {{ __('Waypoints') }}
                                    </a>
                                    <a class="dropdown-item btn small ghost" href="{{ route('admin.users.index') }}">
                                        {{ __('Users') }}
                                    </a>
                                    <a class="dropdown-item btn small ghost" href="{{ route('admin.societies.index') }}">
                                        {{ __('Societies') }}
                                    </a>
                                    <a class="dropdown-item btn small ghost" href="{{ route((auth()->id()===1?'admin':'pro').'.itins.index') }}">
                                        {{ __('Itineraries') }}
                                    </a>
                                <a class="dropdown-item btn small ghost" href="{{ route((auth()->id()===1?'admin':'pro').'.reporting.index') }}">
                                        {{ __('Reporting') }}
                                    </a>
                                </div>
                            </div>

                        @endif



                        {{-- If admin-pro, show the admin-pro link --}}
                        {{-- Admin-pro can access admin panel but not users management --}}
                        {{-- Only show if user has role "Admin Pro" (id=2) --}}
                        {{-- and if route 'admin.users.index' exists --}}
                        @auth
                            @php $isAdminPro = (int)(auth()->user()->role_id ?? 0) === 2; @endphp
                            @if($isAdminPro)
                                <div class="dropdown admin-dropdown">
                                    <button class="btn small ghost dropdown-toggle" type="button" aria-haspopup="true" aria-expanded="false">
                                        {{ __('Admin Pro') }} ▾
                                    </button>
                                    <div class="dropdown-menu" role="menu" style="position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                        <a class="dropdown-item btn small ghost" href="{{ route('pro.points.index') }}">
                                            {{ __('Waypoints') }}
                                        </a>
                                        <a class="dropdown-item btn small ghost" href="{{ route('pro.users.index') }}">
                                            {{ __('Users') }}
                                        </a>
                                        <a class="dropdown-item btn small ghost" href="{{ route('pro.society.edit', ['locale'=>app()->getLocale()]) }}">
                                            {{ __('Society') }}
                                        </a>
                                        <a class="dropdown-item btn small ghost" href="{{ route((auth()->id()===1?'admin':'pro').'.itins.index') }}">
                                            {{ __('Itineraries') }}
                                        </a> 
                                    </div>
                                </div>
                            @endif
                        @endauth



                        {{-- User menu (avatar + dropdown) --}}
                        <div class="dropdown" style="float:right; position:relative">
                           <button type="button" class="btn small ghost" id="user-menu-btn" aria-haspopup="true" aria-expanded="false" style="display:inline-flex;align-items:center;gap:6px">

                                @php $avatar = $u->photo ? Storage::url($u->photo) : '/assets/images/logo_128.png'; @endphp    
    
                                <img src="{{ $avatar }}" alt="avatar" height="18" width="18" style="border-radius:999px;object-fit:cover;border:1px solid #e5e7eb">

                                <span style="font-weight:600">{{ $u->firstname ?? $u->name ?? 'Compte' }} ▾</span>
                            </button>
                            <div id="user-menu" class="card dropdown-menu" style="display:none;position:absolute;right:0;top:100%;margin-top:6px;min-width:200px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                                <a class="btn small ghost" href="{{ lr('user.edit') }}" style="width:100%;text-align:left">{{ __('My informations') }}</a>
    
                                <form id="logout-form" method="POST" action="{{ route('logout', ['locale'=>app()->getLocale()]) }}" style="display:none;">
                                    @csrf
                                </form>

                                <a class="btn small danger" style="margin:6px 0 0; width: 100%;" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    {{ __('Log out') }}
                                </a>
                            </div>
 
                        </div>
                    @else

                        @guest
                            {{-- Show “Login” and “Register” links --}}
                            {{-- If on login/register, show the other one --}}
                            {{-- If on home, show both --}}
                            <div class="dropdown" style="float:right; position:relative">
                                <button type="button" class="btn small ghost" id="user-menu-btn" aria-haspopup="true" aria-expanded="false" style="display:inline-flex;align-items:center;gap:6px">
                        
                                    <img src="/assets/images/logo_128.png" alt="avatar" height="18" width="18" style="border-radius:999px;object-fit:cover;border:1px solid #e5e7eb">

                                    <span style="font-weight:600">{{ $u->firstname ?? $u->name ?? 'Compte' }} ▾</span>
                                </button>
                                <div id="user-menu" class="card dropdown-menu" style="">
                                    <a class="btn small danger" style="width:100%;text-align:left" href="{{ lr('login') }}">{{ __('Log in') }}</a>
                                    <a class="btn small ghost" style="width:100%;text-align:left; margin-top:6px;" href="{{ lr('register') }}">{{ __('Create account') }}</a>
                                </div>
                            </div>
                        @else
                            <form method="POST" action="{{ route('logout', ['locale' => app()->getLocale()]) }}" style="display:inline">
                                @csrf
                                <button class="btn small ghost" type="submit">{{ __('Log out') }}</button>
                            </form>
                        @endguest
                    @endauth




                    {{-- Language switcher --}}
 
                    @php
                        $current = app()->getLocale();
                        $locales = config('locales.supported'); // si pas de View::share
                    @endphp

                     <div class="dropdown lang-dropdown" style="position:relative">
                        {{-- <div class="lang-switcher"> --}}
                        <button type="button"
                                class="btn small ghost dropdown-toggle"
                                id="lang-menu-btn"
                                aria-haspopup="true"
                                aria-expanded="false"
                                style="display:inline-flex;align-items:center;gap:6px;">
                            {{ $locales[$current]['flag'] ?? '' }} {{ strtoupper($current) }} ▾
                        </button>
                         <div id="lang-menu"
                            class="card dropdown-menu"
                            style="display:none;position:absolute;right:0;top:100%;margin-top:6px;min-width:140px;background:#fff;border:1px solid #1f2430;border-radius:10px;padding:8px;z-index:900">
                            {{-- <div class="menu"> --}}
                            @foreach($locales as $code => $meta)
                                @continue($code === $current)
                                <a href="{{ url('/'.$code) }}">
                                    <span class="btn small ghost" style="width: 100%;">{{ $meta['flag'] ?? '' }} {{ $meta['label'] }}</span><br>
                                </a>
                            @endforeach
                        </div>
                    </div>


                </nav>
            </div>
        </header>

        <main>
            @yield('content')
        </main>



        {{-- Cookie consent RGPC banner --}}
        @if(!request()->cookies->has('cookie_consent'))
            <div id="cookie-banner" style="
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background: rgba(15,15,15,0.95);
                color: #fff;
                padding: 16px 20px;
                font-size: 14px;
                z-index: 10000;
                display: flex;
                flex-wrap: wrap;
                align-items: center;
                justify-content: space-between;
            ">
            <div style="flex:1 1 auto; max-width: 750px; line-height:1.5;">
                {{ __('We use cookies to improve your browsing experience and analyze site traffic. By continuing, you agree to our use of cookies. You can withdraw your consent at any time in your browser settings.') }}
            </div>

            <div style="flex: 0 0 auto; display:flex; gap:10px; margin-left:20px;">
                <button id="accept-cookies" class="btn primary" style="background:#3a6cff; border:none; color:white; padding:6px 14px; border-radius:6px;">
                {{ __('Accept') }}
                </button>
                <button id="decline-cookies" class="btn ghost" style="background:none; border:1px solid #aaa; color:#ddd; padding:6px 14px; border-radius:6px;">
                {{ __('Refuse') }}
                </button>
            </div>
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', () => {
                    const acceptBtn = document.getElementById('accept-cookies');
                    const declineBtn = document.getElementById('decline-cookies');
                    const banner = document.getElementById('cookie-banner');

                    function setConsent(value) {
                        const expires = new Date();
                        expires.setFullYear(expires.getFullYear() + 1);
                        document.cookie = "cookie_consent=" + value + "; path=/; expires=" + expires.toUTCString() + "; SameSite=Lax";
                        banner.style.display = 'none';
                    }

                    acceptBtn.addEventListener('click', () => setConsent('accepted'));
                    declineBtn.addEventListener('click', () => setConsent('declined'));
                });
            </script>
        @endif


        <script>
            document.addEventListener('click', (e) => {
                const dropdowns = [
                    { btn: document.getElementById('user-menu-btn'), menu: document.getElementById('user-menu') },
                    { btn: document.getElementById('lang-menu-btn'), menu: document.getElementById('lang-menu') },
                ];

                dropdowns.forEach(({ btn, menu }) => {
                    if (!btn || !menu) {
                        return;
                    }

                    const clickedToggle = btn.contains(e.target);
                    const clickedInside = menu.contains(e.target);

                    if (clickedToggle) {
                        e.preventDefault();
                        const isOpen = menu.style.display === 'block';
                        menu.style.display = isOpen ? 'none' : 'block';
                        btn.setAttribute('aria-expanded', (!isOpen).toString());
                    } else if (!clickedInside) {
                        menu.style.display = 'none';
                        btn.setAttribute('aria-expanded', 'false');
                    }
                });
            });

            document.addEventListener('click', (e) => {
                // Ferme tous les dropdowns si clic à l'extérieur
                document.querySelectorAll('.dropdown.open').forEach(d => {
                    if (!d.contains(e.target)) d.classList.remove('open');
                });

                const toggle = e.target.closest('.dropdown-toggle');
                if (toggle && toggle.closest('.dropdown')) {
                    const dd = toggle.closest('.dropdown');
                    dd.classList.toggle('open');
                }
            });

        </script>

    </body>
</html>
