@extends('layouts.base')
@section('title','{{ __('My waypoints') }}')
@section('content')
    <h1>{{ __('My waypoints') }}</h1>

    @if(session('ok'))
        <div style="background:#e6ffed;border:1px solid #9ae6b4;padding:.75rem;border-radius:6px;margin:.75rem 0">
            {{ session('ok') }}
        </div>
    @endif

    <p>
        <a href="{{ url('/map') }}" class="button">{{ __('New waypoint') }}</a>
    </p>

    <table style="width:100%;border-collapse:collapse">
        <thead>
            <tr>
                <th style="text-align:left;padding:.5rem;border-bottom:1px solid #ddd">{{ __('Name') }}</th>
                <th style="text-align:left;padding:.5rem;border-bottom:1px solid #ddd">{{ __('Coordinates') }}</th>
                <th style="text-align:left;padding:.5rem;border-bottom:1px solid #ddd">{{ __('Owner') }}</th>
                <th style="text-align:left;padding:.5rem;border-bottom:1px solid #ddd">{{ __('Actions') }}</th>
            </tr>
        </thead>
        <tbody>
        @forelse($points as $p)
            <tr>
                <td style="padding:.5rem;border-bottom:1px solid #f0f0f0;">
                    {{ $p->name }}
                </td>
                <td style="padding:.5rem;border-bottom:1px solid #f0f0f0;">
                    {{ $p->latitude }}, {{ $p->longitude }}
                </td>
                <td style="padding:.5rem;border-bottom:1px solid #f0f0f0;">
                    {{ optional($p->owner)->firstname }} {{ optional($p->owner)->lastname }}
                    <small style="color:#666">{{ optional($p->owner)->email }}</small>
                </td>
                <td style="padding:.5rem;border-bottom:1px solid #f0f0f0;">
                    <a href="{{ route('admin.points.edit', $p) }}">{{ __('Edit') }}</a>
                </td>
            </tr>
        @empty
            <tr><td colspan="4" style="padding:.75rem">{{ __('No waypoint found') }}</td></tr>
        @endforelse
        </tbody>
    </table>

    <div style="margin-top:1rem">
        {{ $points->links() }}
    </div>
@endsection