{{-- resources/views/points/public_show.blade.php --}}
@extends('layouts.base')



@php
    /** @var \App\Models\Point|null $p */
    $pt = $p ?? null;
    
    
 // ← always from route param {token}
    $routeToken  = request()->route('token');
    $serialToken = $serialToken ?? $routeToken ?? ($pt->serial ?? null);
 
    $serial       = $serialToken ?? ($pt->serial ?? null);

    // URLs médias
    $photoUrl = ($pt && !empty($pt->photo))  ? Storage::url($pt->photo)  : null;
    $qrUrl    = ($pt && !empty($pt->qrcode)) ? Storage::url($pt->qrcode) : null;

    // Read-only URL
    $readonlyUrl = $serialToken ? route('points.public.readonly', ['locale' => app()->getLocale(), 'token' => $serialToken]) : null;

    // Adresse complète (chaînes uniquement)
    $fullAddress = $pt ? trim(implode(' ', array_filter([
        $pt->address1 ?? null, $pt->address2 ?? null,
        $pt->postcode ?? null, $pt->city ?? null, $pt->country_isocode ?? null,
    ]))) : '';

    // URL de partage (prend readonly si dispo, sinon l’URL courante)
    $shareUrl = url()->current();
    $readonly = (bool)($readonly ?? false);

    $locale = app()->getLocale();
@endphp

@section('title', $pt?->name ? ($pt->name . ' — ' . $serialToken) : __('Waypoint'))

@section('content')
 
    @if(!$pt)
        @php
            $debugInfo = $pt?->serial ? '(' . $pt->serial . ')' : 'bad';
        @endphp
        <div class="wrap">
            <div class="alert danger">
                {{ __('This waypoint does not exist or is no longer available.') }} {{ $debugInfo }} {{ __('Token:') }} <code>{{ $serialToken }}</code>
            </div>
        </div>
        {{-- Lien de secours vers readonly, uniquement si on a le token --}}
        @if(!empty($serialToken))
            <p>
                <a class="btn ghost" href="{{ lr('points.public.readonly', ['token' => $serialToken]) }}">
                {{ __('Open read-only view') }}
                </a>
            </p>
        @endif
    @else
        <div class="wrap">
            <div class="card">
                <div class="card-header">
                    <div class="title">{{ $pt->name }}</div>

                    {{-- Favorite --}}
                    @auth
                        @if($serialToken)
                            <button type="button"
                                class="star-btn fav-btn"
                                data-url="{{ lr('points.favorite', ['token' => $serialToken]) }}"
                                style="line-height:0; background:transparent; border:0; cursor:pointer"
                                aria-label="{{ __('Toggle favorite') }}"
                                title="{{ __('Favorite') }}"
                            >
                                @if((int)($pt->favoris ?? 0) > 0)
                                    <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                        <path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/>
                                    </svg>
                                @else
                                    <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/>
                                    </svg>
                                @endif
                            </button>
                        @endif
                    @endauth
                </div>

                 {{-- Map --}}
                <div class="card-body">
                    <div class="panel">
                        <h4>{{ __('Map') }}</h4>
                        <div id="map" class="leaflet-container"></div>

                        @if($pt && $pt->latitude && $pt->longitude)
                            <div class="map-actions" style="margin-top:1rem; text-align:center; display:flex; gap:1rem; justify-content:center; flex-wrap:wrap;">

                                {{-- Apple Maps --}}
                                <a class="btn small ghost"
                                href="http://maps.apple.com/?daddr={{ $pt->latitude }},{{ $pt->longitude }}"
                                target="_blank" rel="noopener"
                                style="display:flex; align-items:center; gap:.5rem;">
                                    {{-- Icône Apple (pomme) --}}
                                    <svg id="Layer_1" xmlns="http://www.w3.org/2000/svg" version="1.1" width="18" height="18" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M10.6,6.9c.8.2,1.4.4,1.6.4s.9-.1,1.7-.4c.8-.3,1.5-.4,2.1-.4,1,0,1.8.3,2.6.8.4.3.8.7,1.3,1.2-.6.5-1.1,1-1.4,1.4-.5.7-.8,1.6-.8,2.5s.3,1.9.8,2.7c.6.8,1.2,1.3,1.9,1.5-.3,1-.8,2-1.5,3-1,1.6-2.1,2.4-3.1,2.4s-1-.1-1.7-.4c-.7-.3-1.3-.4-1.8-.4s-1.1.1-1.7.4c-.6.3-1.2.4-1.6.4-1.2,0-2.4-1-3.6-3.1-1.2-2.1-1.7-4.1-1.7-6s.4-3.3,1.3-4.5c.9-1.2,2-1.7,3.4-1.7s1.3.1,2.1.4ZM15.8,2.2c0,0,0,.2,0,.2,0,.5-.1,1-.4,1.6-.2.6-.6,1.1-1.1,1.6-.4.4-.9.7-1.3.9-.3,0-.7.2-1.2.2,0-1.2.3-2.2.9-3.1.6-.9,1.6-1.5,3-1.8,0,.1,0,.2,0,.3Z"/>
                                    </svg>
                                    {{ __('Apple Maps') }}
                                </a>

                                {{-- Google Maps --}}
                                <a class="btn small ghost"
                                href="https://www.google.com/maps/dir/?api=1&destination={{ $pt->latitude }},{{ $pt->longitude }}"
                                target="_blank" rel="noopener"
                                style="display:flex; align-items:center; gap:.5rem;">
                                    {{-- Icône Google Maps (simplifiée) --}}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M12 2a7.99 7.99 0 0 0-8 8c0 5.25 8 12 8 12s8-6.75 8-12a7.99 7.99 0 0 0-8-8Zm0 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6Z"/>
                                    </svg>
                                    {{ __('Google Maps') }}
                                </a>

                            </div>
                        @endif

                    </div>
                </div>
                <div class="media-grid">
                    <div class="panel">
                        <h4>{{ __('Media') }}</h4>

                        {{-- PHOTO --}}
                        <div class="imgbox" style="margin-bottom:10px; background: url({{ $photoUrl }}) no-repeat center/contain; min-height:260px">
                            @if($photoUrl)
                                <a href="{{ $photoUrl }}" target="_blank" rel="noopener">
                                    {{-- <img src="{{ $photoUrl }}" alt="Photo du point {{ $pt->name }}"> --}}
                                </a>
                            @else
                                <div style="color:#6b7280;font-size:.9rem;padding:12px">{{ __('No photo') }}</div>
                            @endif
                        </div>

                        {{-- Importer photo --}}
                        @auth
                            @if(!$readonly)
                                <form method="POST"
                                    action="{{ route('points.update.photo', ['locale' => app()->getLocale()]) }}"
                                    enctype="multipart/form-data">
                                {{-- <form method="POST" action="{{ lr('points.update.photo', ['serial' => $serial]) }}" enctype="multipart/form-data"> --}}
                                    @csrf
                                    @method('PUT')

                                    <input id="photo-input" name="photo" type="file" accept="image/*" hidden onchange="this.form.submit()">
                                    {{-- <input type="hidden" name="serial" value="{{ $serial }}"> --}}
                                    <input type="hidden" name="serial" value="{{ $pt->serial }}">

                                    <button type="button" class="btn primary" style="padding: 2px 18px !important;" onclick="document.getElementById('photo-input').click()">
                                        {{ __('Import') }}
                                    </button>
                                    @if($photoUrl)
                                        <div style="font-size:.85rem; color:#a7acb4;">{{ __('Replace existing photo') }}</div>
                                    @else
                                        <div style="font-size:.85rem; color:#a7acb4;">{{ __('Add a photo') }}</div>
                                    @endif
                                </form>
                            @endif
                        @endauth
                    </div>
                    <div class="panel">
                           <h4>{{ __('QR Code') }}</h4>
                
                        {{-- QR CODE --}}
                        <div class="imgbox">
                            @php
                                //$qrUrl = $point && $point->qrcode ? Storage::url($point->qrcode) : null;
                                $qrUrl = $pt->qrcode ? Storage::url($pt->qrcode) : null;
                            @endphp
                                @if($qrUrl)
                                    <a href="{{ $qrUrl }}" target="_blank" rel="noopener">
                                        <img
                                        src="{{ $qrUrl }}"
                                        alt="QR Code"
                                        width="256" height="256"
                                        loading="lazy" decoding="async"
                                        style="display:block;max-width:100%;height:auto"
                                        onerror="this.replaceWith(Object.assign(document.createElement('object'),{data:this.src,type:'image/svg+xml',width:this.width,height:this.height}));"
                                        >
                                    </a>
                                @else
                                    <div class="alert">{{ __('QR code unavailable') }}</div>
                                @endif
                            </div>

                        </div>
                    </div>
                </div>

                {{-- Infos clés --}}
                 <div class="form-card" >
                    @unless(empty($readonly))
                        <div class="kv">
                        
                            <div class="key">{{ __('Coordinates') }}</div>
                            <div class="val">
                                <span>lat :</span> {{ number_format((float)$pt->latitude, 6, '.', ' ') }} <br>
                                <span>lon :</span> {{ number_format((float)$pt->longitude, 6, '.', ' ') }} <br>
                                @if(!is_null($pt->altitude))
                                    <span>alt :</span> {{ (float)$pt->altitude }} m<br>
                                @endif
                                @if(!is_null($pt->floor) && $pt->floor > 0)
                                    <span>floor :</span> {{ (float)$pt->floor }}<br>
                                @endif
                            </div>

                            @if($fullAddress !== '')
                                <div class="key">{{ __('Address') }}</div>
                                <div class="val">{{ $fullAddress }}</div>
                            @endif

                            @if(!empty($pt->comment))
                                <div class="key">{{ __('Comment') }}</div>
                                <div class="val">{{ $pt->comment }}</div>
                            @endif

                            {{-- Show the report button only on read-only view (/w/{token}) --}}
                            @if(!empty($readonly) && $readonly === true && isset($pt))
                                <div style="margin-top:14px">
                                    <button type="button" class="btn danger" id="open-report-modal">
                                        {{ __('Report this waypoint') }}
                                    </button>
                                </div>

                                {{-- Lightweight modal --}}
                                <dialog id="report-modal" style="max-width: 520px; width: 92%; border:1px solid #1f2430; border-radius:10px; padding:0;">
                                    <form method="POST" action="{{ route('reporting.store') }}" style="padding:16px 16px 8px 16px">
                                        @csrf

                                        <h3 style="margin:0 0 10px 0">{{ __('Report this waypoint') }}</h3>
                                        <p style="color:#9aa0a6; margin-top:0">{{ __('Tell us what is wrong or why this waypoint should be reviewed.') }}</p>

                                        <input type="hidden" name="point_id" value="{{ $pt->id }}"/>

                                        <div class="form-field" style="margin-bottom:10px">
                                            <label for="report-email" style="display:block; font-weight:600">{{ __('Your email (optional)') }}</label>
                                            <input id="report-email" type="email" name="email" placeholder="you@example.com" style="width:100%">
                                        </div>

                                        <div class="form-field" style="margin-bottom:12px">
                                            <label for="report-message" style="display:block; font-weight:600">{{ __('Message') }}</label>
                                            <textarea id="report-message" name="message" required rows="5" style="width:100%"></textarea>
                                        </div>

                                        <div style="display:flex; gap:.5rem; justify-content:flex-end; border-top:1px solid #1f2430; padding-top:10px; margin-top:10px;">
                                            <button type="button" id="close-report-modal" class="btn ghost">{{ __('Cancel') }}</button>
                                            <button type="submit" class="btn primary">{{ __('Submit') }}</button>
                                        </div>
                                    </form>
                                </dialog>

                                <script>
                                    (function(){
                                        const openBtn  = document.getElementById('open-report-modal');
                                        const closeBtn = document.getElementById('close-report-modal');
                                        const dialog   = document.getElementById('report-modal');

                                        if (!openBtn || !dialog) return;

                                        openBtn.addEventListener('click', () => {
                                            if (typeof dialog.showModal === 'function') {
                                                dialog.showModal();
                                            } else {
                                                // fallback if <dialog> not supported
                                                dialog.style.display = 'block';
                                            }
                                        });

                                        if (closeBtn) {
                                            closeBtn.addEventListener('click', () => {
                                                if (typeof dialog.close === 'function') {
                                                    dialog.close();
                                                } else {
                                                    dialog.style.display = 'none';
                                                }
                                            });
                                        }
                                    })();
                                </script>
                            @endif
                            <!-- <div class="key">Favori</div>
                            <div class="val" id="kv-favori">{{ (int)($pt->favoris ?? 0) > 0 ? 'Oui' : 'Non' }}</div>-->
                        </div> 
    
                    @endunless

                    {{-- Formulaire de mise à jour (par SERIAL) --}}
                    {{-- <h4 style="margin-top:16px">{{ __('Update waypoint') }}</h4> --}}

                    <div class="hr"></div>

                    {{-- Messages flash --}}
                    @if (session('status'))
                        <div class="alert" style="margin-top:16px">{{ session('status') }}</div>
                    @endif
                    @if ($errors->any())
                        <div class="alert" style="margin-top:16px">
                            <strong>{{ __('Errors') }} :</strong>
                            <ul style="margin:6px 0 0 16px;">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- Formulaire de mise à jour (par SERIAL) --}}
                    @if($pt && !empty($pt->serial) && $serialToken)
                        @unless(!empty($readonly))
                            {{-- route('points.update.serial', ['locale' => app()->getLocale(), 'serial' => $pt->serial ?? $serialToken]) --}}
                            <form method="POST" action="{{ route('points.update.serial', ['locale' => app()->getLocale(), 'serial' => $serialToken]) }}">
                                @csrf
                                @method('PUT')

                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="lastname">{{ __('Name') }}</label>
                                        <input id="lastname" type="text" name="name" value="{{ old('name', $pt->name) }}" required>
                                    </div>
                                 </div>

                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="latitude">{{ __('Latitude') }}</label>
                                        <input id="latitude" type="number" step="0.000001" name="latitude" value="{{ old('latitude', $pt->latitude) }}" required>
                                    </div>
                                    <div class="form-field">
                                        <label for="longitude">{{ __('Longitude') }}</label>
                                        <input id="longitude" type="number" step="0.000001" name="longitude" value="{{ old('longitude', $pt->longitude) }}" required>
                                    </div>
                                    <div class="form-field">
                                        <label for="altitude">{{ __('Altitude') }} (m)</label>
                                        <input id="altitude" type="number" step="0.1" name="altitude" value="{{ old('altitude', $pt->altitude) }}">
                                    </div>
                                    <div class="form-field">
                                        <label for="floor">{{ __('Floor') }} (m)</label>
                                        <input id="floor" type="number" step="0.1" name="floor" value="{{ old('floor', $pt->floor) }}">
                                    </div>
                                </div>

                                {{-- Adresse détaillée alignée BDD --}}
                                <div class="form-grid">
                                    <div class="form-field">
                                        <label for="address1">{{ __('Address1') }}</label>
                                        <input id="address1" type="text" name="address1" value="{{ old('address1', $pt->address1) }}">
                                     </div>
                                    <div class="form-field">
                                        <label for="address2">{{ __('Address2') }} </label>
                                        <input id="address2" type="text" name="address2" value="{{ old('address2', $pt->address2) }}">
                                    </div>
                                </div>

                                 <div class="form-grid">
                                    <div class="form-field">
                                        <label for="postcode">{{ __('Postcode') }}</label>
                                        <input id="postcode" type="text" name="postcode" value="{{ old('postcode', $pt->postcode) }}">
                                    </div>
                                     <div class="form-field">
                                        <label for="city">{{ __('City') }}</label>
                                        <input id="city" type="text" name="city" value="{{ old('city', $pt->city) }}">
                                     </div>
                                     <div class="form-field">
                                        <label for="country_isocode">{{ __('country_isocode') }}</label>
                                        <input id="country_isocode" type="text" name="country_isocode" value="{{ old('country_isocode', $pt->country_isocode) }}">
                                    </div>
                                </div>

                                 <div class="form-grid">
                                    <div class="form-field">
                                        <label for="comment">{{ __('Comment') }}</label>
                                        <textarea id="comment" name="comment">{{ old('comment', $pt->comment) }}</textarea>
                                    </div>
                                </div>

                                <div class="actions">
                                <a href="{{ url()->previous() }}" class="btn">{{ __('Cancel') }}</a>
                                <button class="btn primary" type="submit">{{ __('Save') }}</button>
                                </div>
                            </form>
                        @endunless
                    @endif
                    </div>
                </div>
            </div>
        </div>





        {{-- Exemple d’utilisation des URLs protégées --}}
        {{-- @if($readonlyUrl)
            <a class="btn small ghost" href="{{ $readonlyUrl }}" target="_blank">
                {{ __('Public page (read only)') }}
            </a>
        @endif --}}
        {{-- évite toute référence à token si null --}}






       {{-- Leaflet (CDN) --}}
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
        <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" defer></script>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const mapEl = document.getElementById('map');
                if (!mapEl) return;
                if (typeof window.L === 'undefined') { console.error('Leaflet non chargé'); return; }

                const lat = {{ (float)$pt->latitude }};
                const lon = {{ (float)$pt->longitude }};

                const map = L.map('map', { scrollWheelZoom: true }).setView([lat, lon], 14);
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19, attribution: '&copy; OpenStreetMap'
                }).addTo(map);

                L.marker([lat, lon]).addTo(map).bindPopup({!! json_encode($pt->name) !!});
            });







            // Favorite
        document.addEventListener('click', async (e) => {
            const btn = e.target.closest('.fav-btn');
            if (!btn) return;

            const url = btn.dataset?.url;
            if (!url) return;

            try {
                const res = await fetch(url, {
                method: 'POST',
                credentials: 'same-origin', // 👈 indispensable pour envoyer le cookie de session
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                },
                });

                if (res.status === 401) {
                    // pas connecté → redirige vers login localisé
                    window.location.href = "{{ lr('login') }}";
                    return;
                }

                if (res.status === 403) {
                    const j = await res.json().catch(()=>({}));
                    alert(j?.error === 'forbidden'
                    ? "Action non autorisée (réservée au propriétaire ou super-admin)."
                    : "Action interdite.");
                    return;
                }

                const text = await res.text();
                let json = null;
                try { json = JSON.parse(text); } catch(_) {}

                if (!res.ok) {
                    console.error('Favorite toggle failed', res.status, url, text || json);
                    alert('Impossible de mettre à jour le favori pour le moment.');
                    return;
                }

                const favoris = json?.favoris ?? null;
                if (favoris === null) {
                    console.error('Favorite response missing "favoris"', json);
                    alert('Impossible de mettre à jour le favori pour le moment.');
                    return;
                }

                // Met à jour l’icône (plein/vide)
                const filled = `<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>`;
                const empty  = `<svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21 12 17.77 5.82 21 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>`;
                btn.innerHTML = (Number(favoris) > 0) ? filled : empty;
            } catch (err) {
                console.error('Favorite network error', err);
                alert('Impossible de mettre à jour le favori pour le moment.');
            }
        });







            // Partage
            document.addEventListener('DOMContentLoaded', () => {
            const shareBtn = document.getElementById('share-btn');
            const fallback = document.getElementById('share-fallback');
            const copyBtn  = document.getElementById('copy-link-btn');

            if (shareBtn) {
                shareBtn.addEventListener('click', async () => {
                const title = shareBtn.dataset.title || 'Partager';
                const text  = shareBtn.dataset.text  || '';
                const url   = shareBtn.dataset.url   || location.href;

                if (navigator.share) {
                    try { await navigator.share({ title, text, url }); }
                    catch (err) { if (!err || err.name !== 'AbortError') { if (fallback) fallback.style.display = 'block'; } }
                } else {
                    if (fallback) fallback.style.display = 'block';
                }
                });
            }

            if (copyBtn) {
                copyBtn.addEventListener('click', async () => {
                const url = copyBtn.dataset.url || location.href;
                try {
                    await navigator.clipboard.writeText(url);
                    copyBtn.textContent = 'Lien copié ✓';
                    setTimeout(() => (copyBtn.textContent = 'Copier le lien'), 1500);
                } catch {
                    const ta = document.createElement('textarea');
                    ta.value = url; document.body.appendChild(ta); ta.select(); document.execCommand('copy'); document.body.removeChild(ta);
                    copyBtn.textContent = 'Lien copié ✓';
                    setTimeout(() => (copyBtn.textContent = 'Copier le lien'), 1500);
                }
                });
            }
            });
        </script>

    @endif 


@endsection