{{-- resources/views/pro/itins/create.blade.php --}}
@extends('layouts.base')

@section('title', __('Create an itinerary'))

@section('content')
<div class="wrap">
  <h2 style="margin:0 0 12px;">{{ __('Create an itinerary') }}</h2>

  @if($errors->any())
    <div class="alert danger">
      <ul style="margin:0 0 0 16px;">
        @foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach
      </ul>
    </div>
  @endif

  <form method="POST" action="{{ route('pro.itins.store', ['locale'=>app()->getLocale()]) }}">
    @csrf

    <div class="card" style="max-width:980px;">
      <div class="card-body">

        {{-- Name (unique) --}}
        <div class="form-field">
          <label for="name">{{ __('Name') }}</label>
          <input id="name" type="text" name="name" required value="{{ old('name') }}" placeholder="Ex: Livraison secteur Ouest">
        </div>

        {{-- Assigned manager is always the current Pro admin --}}
        <input type="hidden" name="assigned_user_id" value="{{ auth()->id() }}">

        {{-- Company (fixed to current Pro admin’s company) --}}
        <div class="form-field">
          <label>{{ __('Company') }}</label>
          <input type="text" value="{{ $society?->name ?? '—' }}" disabled>
          <input type="hidden" name="society_id" value="{{ $society?->id }}">
        </div>

        {{-- Assigned users (company members, id > 1) --}}
        <div class="form-field">
          <label>{{ __('Assigned users (company members)') }}</label>
          <div style="display:grid; grid-template-columns: repeat(auto-fit,minmax(240px,1fr)); gap:8px;">
            @forelse($companyUsers as $u)
              <label class="chk">
                <input type="checkbox" name="assigned_user_ids[]" value="{{ $u->id }}">
                <span>{{ $u->firstname }} {{ $u->lastname }}</span>
                <small class="muted">— {{ $u->email }}</small>
              </label>
            @empty
              <div class="muted">{{ __('No users found for your company (excluding root).') }}</div>
            @endforelse
          </div>
        </div>

        {{-- (Optional) Waypoints info --}}
        <div class="form-field">
          <label>{{ __('Waypoints') }}</label>
          <div class="muted">{{ __('You can attach waypoints after creating the itinerary (edit screen).') }}</div>
        </div>


        <div class="form-field">
            <label>{{ __('Waypoints') }}</label>
            <div class="muted" style="margin-bottom:6px;">
                {{ __('Pick among your available waypoints, then drag to order.') }}
            </div>

            <div style="display:grid; grid-template-columns: 1fr 1fr; gap:12px;">
                <div class="panel">
                    <h4 style="margin:0 0 8px;">{{ __('Available') }}</h4>
                    <div id="available-points" class="list" style="border:var(--border); border-radius:8px; padding:8px; min-height:180px;">
                        <div class="muted" data-empty>{{ __('Loading…') }}</div>
                    </div>
                </div>

                <div class="panel">
                    <h4 style="margin:0 0 8px;">{{ __('Selected (drag to reorder)') }}</h4>
                    <div id="selected-points" class="list droplist" style="border:var(--border); border-radius:8px; padding:8px; min-height:180px;">
                        <div class="muted" data-empty>{{ __('No waypoint selected yet.') }}</div>
                    </div>
                    <div id="point-ids-hidden"></div>
                </div>
            </div>
        </div>


        <div class="actions" style="margin-top:12px; display:flex; gap:8px;">
          <a class="btn ghost" href="{{ route('pro.itins.index', ['locale'=>app()->getLocale()]) }}">{{ __('Back') }}</a>
          <button class="btn primary" type="submit">{{ __('Create') }}</button>
        </div>
      </div>
    </div>
  </form>
</div>



@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            const boxAvail = document.getElementById('available-points');
            const boxSel   = document.getElementById('selected-points');
            const hidden   = document.getElementById('point-ids-hidden');

            const tplItem = (id, name) => {
                const li = document.createElement('div');
                li.className = 'row';
                li.draggable = true;
                li.dataset.id = String(id);
                li.style.cssText = 'display:flex; align-items:center; justify-content:space-between; gap:8px; padding:6px 8px; border:1px solid var(--border-color,#1f2430); border-radius:6px; margin-bottom:6px; ';
                li.innerHTML = `<span>${name}</span>
                                <div style="display:flex; gap:6px;">
                                <button type="button" class="btn small ghost add">{{ __('Add') }}</button>
                                <button type="button" class="btn small danger remove" style="display:none;">{{ __('Remove') }}</button>
                                </div>`;
                return li;
            };

            const clearEmpty = (el) => { const emp = el.querySelector('[data-empty]'); if (emp) emp.remove(); };

            function updateHidden() {
                hidden.innerHTML = '';
                boxSel.querySelectorAll('[data-id]').forEach((el) => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'point_ids[]';
                    input.value = el.dataset.id;
                    hidden.appendChild(input);
                });
            }

            function makeDraggable(container) {
                let dragEl = null;
                container.addEventListener('dragstart', (e) => {
                    const row = e.target.closest('.row'); if (!row) return;
                    dragEl = row;
                    e.dataTransfer.effectAllowed = 'move';
                });
                container.addEventListener('dragover', (e) => {
                    if (!dragEl) return;
                    e.preventDefault();
                    const after = [...container.querySelectorAll('.row')].find(r => {
                        const rect = r.getBoundingClientRect();
                        return e.clientY < rect.top + rect.height/2;
                    });
                    if (after) container.insertBefore(dragEl, after); else container.appendChild(dragEl);
                });
                container.addEventListener('drop', () => { dragEl = null; updateHidden(); });
                container.addEventListener('dragend', () => { dragEl = null; updateHidden(); });
            }
            makeDraggable(boxSel);

            document.body.addEventListener('click', (e) => {
                const addBtn = e.target.closest('.add');
                const remBtn = e.target.closest('.remove');
                if (addBtn) {
                const row = addBtn.closest('.row'); if (!row) return;
                clearEmpty(boxSel);
                row.querySelector('.add').style.display = 'none';
                row.querySelector('.remove').style.display = '';
                boxSel.appendChild(row);
                updateHidden();
                }
                if (remBtn) {
                const row = remBtn.closest('.row'); if (!row) return;
                row.querySelector('.add').style.display = '';
                row.querySelector('.remove').style.display = 'none';
                boxAvail.appendChild(row);
                if (!boxSel.querySelector('.row')) {
                    boxSel.innerHTML = `<div class="muted" data-empty>{{ __('No waypoint selected yet.') }}</div>`;
                }
                updateHidden();
                }
            });

            // Load my points on load
            try {
                const url = @json(route('pro.itins.myPoints', ['locale'=>app()->getLocale()]));
                const res = await fetch(url, { headers: { 'Accept': 'application/json' }});
                const list = res.ok ? await res.json() : [];
                boxAvail.innerHTML = '';
                if (!Array.isArray(list) || list.length === 0) {
                boxAvail.innerHTML = '<div class="muted">{{ __('No waypoint available.') }}</div>';
                return;
                }
                list.forEach(p => boxAvail.appendChild(tplItem(p.id, p.name || ('#'+p.id))));
                clearEmpty(boxAvail);
            } catch (err) {
                console.error(err);
                boxAvail.innerHTML = '<div class="alert danger">{{ __('Unable to load waypoints') }}</div>';
            }
            });
        </script>
    @endpush
@endsection