{{-- resources/views/pro/itins/edit.blade.php --}}
@extends('layouts.base')

@php
    /** @var \Illuminate\Support\Collection|\App\Models\User[] $adminPros */
    $adminPros = $adminPros ?? collect();
@endphp

@section('title', __('Edit itinerary') . ' — ' . $itinerary->name)

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">
        {{ __('Edit itinerary') }} <small style="color:#8b90a0">#{{ $itinerary->id }}</small>
    </h2>

    @if(session('ok')) <div class="alert success">{{ session('ok') }}</div> @endif
    @if($errors->any())
        <div class="alert danger">
            <ul style="margin:0 0 0 16px;">
                @foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.itins.update', ['locale'=>app()->getLocale(), 'itinerary'=>$itinerary->id]) }}">
        @csrf
        @method('PUT')

        <div class="card" style="max-width:980px;">
            <div class="card-body">

                {{-- Name --}}
                <div class="form-field">
                    <label for="name">{{ __('Name') }}</label>
                    <input id="name" type="text" name="name" required value="{{ old('name', $itinerary->name) }}">
                </div>

                {{-- Organizer (Pro admin) --}}
                <div class="form-field">
                    <label for="admin_pro_id">{{ __('Organizer (Pro admin)') }}</label>
                    <select id="admin_pro_id" name="admin_pro_id" required>
                        @foreach($adminPros as $ap)
                            @php $socName = $ap->societies->first()->name ?? '—'; @endphp
                            <option value="{{ $ap->id }}" {{ (int)$itinerary->organizer_id === (int)$ap->id ? 'selected' : '' }}>
                                {{ $ap->firstname }} {{ $ap->lastname }} — {{ $socName }}
                            </option>
                        @empty
                            <div class="muted">{{ __('No pro admin for this company.') }}</div>
                        @endforelse 
                    </select>
                </div>

                {{-- Society (fixed to itinerary’s company, editable si souhaité) --}}
                <div class="form-field">
                    <label for="society_id">{{ __('Company') }}</label>
                    <input type="number" id="society_id" name="society_id"
                           value="{{ old('society_id', $targetSocietyId) }}" required>
                    <small class="muted">{{ $itinerary->society->name ?? '—' }}</small>
                </div>

                {{-- Assigned users (company users, id > 1) --}}
                <div class="form-field">
                    <label>{{ __('Assigned users') }}</label>
                    <div style="display:grid; grid-template-columns: repeat(auto-fit,minmax(240px,1fr)); gap:8px;">
                        @forelse($companyUsers as $u)
                            <label class="chk">
                                <input type="checkbox" name="assigned_user_ids[]" value="{{ $u->id }}"
                                       {{ in_array($u->id, $assignedIds ?? [], true) ? 'checked' : '' }}>
                                <span>{{ $u->firstname }} {{ $u->lastname }}</span>
                                <small class="muted">— {{ $u->email }}</small>
                            </label>
                        @empty
                            <div class="muted">{{ __('No users found for this company (excluding root).') }}</div>
                        @endforelse
                    </div>
                </div>

                <div class="actions" style="margin-top:12px; display:flex; gap:8px;">
                    <a class="btn ghost" href="{{ route('admin.itins.index', ['locale'=>app()->getLocale()]) }}">{{ __('Back') }}</a>
                    <button class="btn primary" type="submit">{{ __('Save') }}</button>

                    {{-- Delete --}}
                    <form method="POST" action="{{ route('admin.itins.destroy', ['locale'=>app()->getLocale(), 'itinerary'=>$itinerary->id]) }}"
                          onsubmit="return confirm('{{ __('Delete this itinerary?') }}');" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button class="btn danger" type="submit">{{ __('Delete') }}</button>
                    </form>
                </div>

            </div>
        </div>
    </form>
</div>
@endsection