{{-- resources/views/pro/points/index.blade.php --}}
@extends('layouts.base')

@section('title', __('Waypoints'))

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">{{ __('Waypoints') }}</h2>

    {{-- Flash messages --}}
    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif
    @if($errors->any())
        <div class="alert danger">
            <ul style="margin:0 0 0 16px;">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Simple table list --}}
    @if($points->isEmpty())
        <div class="alert">{{ __('No waypoint found for your company.') }}</div>
    @else
        <div class="table-responsive">
            <table class="table" style="width:100%;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('City') }}</th>
                        <th>{{ __('Coordinates') }}</th>
                        <th>{{ __('Serial') }}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                @foreach($points as $p)
                    <tr>
                        <td>{{ $p->id }}</td>
                        <td>{{ $p->name }}</td>
                        <td>{{ $p->city ?? '—' }}</td>
                        <td>
                            @if($p->latitude && $p->longitude)
                                {{ number_format((float)$p->latitude, 6, '.', ' ') }},
                                {{ number_format((float)$p->longitude, 6, '.', ' ') }}
                            @else
                                —
                            @endif
                        </td>
                        <td><code>{{ $p->serial ?? '—' }}</code></td>
                        <td style="white-space:nowrap;">
                            @if(!empty($p->serial))
                                {{-- Link to public read-only page --}}
                                <a class="btn small ghost"
                                   href="{{ lr('points.public.readonly', ['token' => $p->serial]) }}"
                                   target="_blank" rel="noopener">
                                    {{ __('Open') }}
                                </a>
                            @else
                                <span class="muted">—</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div style="margin-top:12px;">
            {{ $points->links() }}
        </div>
    @endif
</div>
@endsection