{{-- resources/views/pro/society/edit.blade.php --}}
@extends('layouts.base')

@section('title', __('Company'))

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">{{ __('Company details') }}</h2>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif
    @if($errors->any())
        <div class="alert danger">
            <ul style="margin:0 0 0 16px;">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card" style="max-width:900px;">
        <div class="card-header">
            <div class="title">{{ $society->name }}</div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('pro.society.update', ['locale'=>app()->getLocale()]) }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="form-field">
                    <label for="name">{{ __('Name') }}</label>
                    <input id="name" type="text" name="name" required value="{{ old('name', $society->name) }}">
                </div>

                <div class="form-grid">
                    <div class="form-field">
                        <label for="street">{{ __('Street') }}</label>
                        <input id="street" type="text" name="street" value="{{ old('street', $society->street) }}">
                    </div>
                    <div class="form-field">
                        <label for="postcode">{{ __('Postcode') }}</label>
                        <input id="postcode" type="text" name="postcode" value="{{ old('postcode', $society->postcode) }}">
                    </div>
                </div>

                <div class="form-grid">
                    <div class="form-field">
                        <label for="city">{{ __('City') }}</label>
                        <input id="city" type="text" name="city" value="{{ old('city', $society->city) }}">
                    </div>
                    <div class="form-field">
                        <label for="country">{{ __('Country') }}</label>
                        <input id="country" type="text" name="country" value="{{ old('country', $society->country) }}">
                    </div>
                </div>

                <div class="form-grid">
                    <div class="form-field">
                        <label for="phone">{{ __('Phone') }}</label>
                        <input id="phone" type="text" name="phone" value="{{ old('phone', $society->phone) }}">
                    </div>
                    <div class="form-field">
                        <label for="email">{{ __('Email') }}</label>
                        <input id="email" type="email" name="email" value="{{ old('email', $society->email) }}">
                    </div>
                </div>

                {{-- <div class="form-field">
                    <label for="subscribed_at">{{ __('Subscribed at') }}</label>
                    <input id="subscribed_at" type="date" name="subscribed_at"
                           value="{{ old('subscribed_at', optional($society->subscribed_at)->format('Y-m-d')) }}">
                </div> --}}

                <div class="form-field">
                    <label>{{ __('Logo / Photo') }}</label>

                    @if($society->photo)
                        <div style="margin:8px 0">
                            <img src="{{ Storage::url($society->photo) }}" alt="Logo" style="max-height:120px;border-radius:8px">
                        </div>
                        <label style="display:flex;align-items:center;gap:.5rem;">
                            <input type="checkbox" name="remove_photo" value="1">
                            <span>{{ __('Remove current image') }}</span>
                        </label>
                    @endif

                    <input type="file" name="photo" accept="image/*">
                    <small class="muted">{{ __('PNG/JPG up to 4MB') }}</small>
                </div>

                <div class="actions" style="margin-top:12px;">
                    <button class="btn primary" type="submit">{{ __('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection