{{-- resources/views/pro/society/show.blade.php --}}
@extends('layouts.base')

@section('title', __('Company'))

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">{{ __('Company details') }}</h2>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif

    @if(empty($society))
        <div class="alert danger">{{ __('No company attached to your account.') }}</div>
    @else
        <div class="card" style="margin-bottom:16px;">
            <div class="card-header">
                <div class="title">{{ $society->name }}</div>
            </div>
            <div class="card-body">
                <div class="kv">
                    <div class="key">{{ __('Address') }}</div>
                    <div class="val">
                        {{ $society->street ?? '' }}<br>
                        {{ $society->postcode ?? '' }} {{ $society->city ?? '' }} {{ $society->country ?? '' }}
                    </div>

                    @if(!empty($society->phone))
                        <div class="key">{{ __('Phone') }}</div>
                        <div class="val">{{ $society->phone }}</div>
                    @endif

                    @if(!empty($society->email))
                        <div class="key">{{ __('Email') }}</div>
                        <div class="val">{{ $society->email }}</div>
                    @endif

                    @if(!empty($society->subscribed_at))
                        <div class="key">{{ __('Subscribed at') }}</div>
                        <div class="val">{{ \Illuminate\Support\Carbon::parse($society->subscribed_at)->format('Y-m-d') }}</div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Company users (Admin Pro + Pro) --}}
        <h3 style="margin:0 0 8px;">{{ __('Company users') }}</h3>

        @php
            // if controller eager loads: $society->users
            $companyUsers = $society->users ?? collect();
        @endphp

        @if($companyUsers->isEmpty())
            <div class="alert">{{ __('No users associated with this company.') }}</div>
        @else
            <p class="muted" style="margin:8px 0;">
                {{ __('Showing :count users (page :page of :pages)', [
                    'count' => $allUsers->total(),
                    'page'  => $allUsers->currentPage(),
                    'pages' => $allUsers->lastPage(),
                ]) }}
            </p>

            <div class="table-responsive">
                <table class="table" style="width:100%;">
                    <thead>
                        <tr>
                            <th>{{ __('Lastname') }}</th>
                            <th>{{ __('Firstname') }}</th>
                            <th>{{ __('Email') }}</th>
                            <th>{{ __('Role') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($allUsers as $u)
                        <tr>
                            <td>{{ $u->lastname ?? '—' }}</td>
                            <td>{{ $u->firstname ?? '—' }}</td>
                            <td>{{ $u->email }}</td>
                            <td>
                                @switch((int)($u->role_id ?? 0))
                                    @case(1) {{ __('Admin') }} @break
                                    @case(2) {{ __('Admin Pro') }} @break
                                    @case(4) {{ __('Pro') }} @break
                                    @default  {{ __('User') }}
                                @endswitch
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div style="margin-top:12px;">
                {{ $allUsers->links() }}
            </div>
        @endif
    @endif
</div>
@endsection