@extends('layouts.base')

@section('title', __('Edit user'))

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">
        {{ __('Edit user') }} — {{ $user->firstname }} {{ $user->lastname }}
    </h2>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif
    @if($errors->any())
        <div class="alert danger">
            <ul style="margin:0 0 0 16px;">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card" style="max-width:900px;">
        <div class="card-header">
            <div class="title">
                {{ __('Company') }} : {{ $society?->name ?? '—' }}
            </div>
        </div>
        <div class="card-body">
            <form method="POST"
                  action="{{ route('pro.users.update', ['locale'=>app()->getLocale(),'user'=>$user->id]) }}"
                  enctype="multipart/form-data">
                @csrf
                @method('PUT')

                {{-- Identity --}}
                <div class="form-grid">
                    <div class="form-field">
                        <label for="lastname">{{ __('Lastname') }}</label>
                        <input id="lastname" type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}">
                    </div>
                    <div class="form-field">
                        <label for="firstname">{{ __('Firstname') }}</label>
                        <input id="firstname" type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}">
                    </div>
                </div>

                {{-- Email / Phone --}}
                <div class="form-grid">
                    <div class="form-field">
                        <label for="email">{{ __('Email') }}</label>
                        <input id="email" type="email" name="email" required value="{{ old('email', $user->email) }}">
                    </div>
                    <div class="form-field">
                        <label for="phone">{{ __('Phone') }}</label>
                        <input id="phone" type="text" name="phone" value="{{ old('phone', $user->phone) }}">
                    </div>
                </div>

                {{-- Address --}}
                <div class="form-grid">
                    <div class="form-field">
                        <label for="address1">{{ __('Address 1') }}</label>
                        <input id="address1" type="text" name="address1" value="{{ old('address1', $user->address1) }}">
                    </div>
                    <div class="form-field">
                        <label for="address2">{{ __('Address 2') }}</label>
                        <input id="address2" type="text" name="address2" value="{{ old('address2', $user->address2) }}">
                    </div>
                </div>

                <div class="form-grid">
                    <div class="form-field">
                        <label for="postcode">{{ __('Postcode') }}</label>
                        <input id="postcode" type="text" name="postcode" value="{{ old('postcode', $user->postcode) }}">
                    </div>
                    <div class="form-field">
                        <label for="city">{{ __('City') }}</label>
                        <input id="city" type="text" name="city" value="{{ old('city', $user->city) }}">
                    </div>
                    <div class="form-field">
                        <label for="country_isocode">{{ __('Country ISO code') }}</label>
                        <input id="country_isocode" type="text" name="country_isocode" value="{{ old('country_isocode', $user->country_isocode) }}">
                    </div>
                </div>

                {{-- Photo --}}
                <div class="form-field">
                    <label for="photo">{{ __('Profile photo') }}</label>
                    @if($user->photo)
                        <div style="margin-bottom:10px">
                            <img src="{{ Storage::url($user->photo) }}" alt="Photo" width="120" height="120" style="border-radius:8px;">
                        </div>
                    @endif
                    <input id="photo" type="file" name="photo" accept="image/*">
                </div>

                {{-- Password --}}
                <div class="form-grid">
                    <div class="form-field">
                        <label for="password">{{ __('New password') }}</label>
                        <input id="password" type="password" name="password">
                        <small class="muted">{{ __('Leave blank to keep the current password') }}</small>
                    </div>
                    <div class="form-field">
                        <label for="password_confirmation">{{ __('Confirm password') }}</label>
                        <input id="password_confirmation" type="password" name="password_confirmation">
                    </div>
                </div>

                {{-- Buttons --}}
                <div class="actions" style="margin-top:12px;">
                    <a class="btn ghost" href="{{ route('pro.users.index', ['locale'=>app()->getLocale()]) }}">{{ __('Cancel') }}</a>
                    <button class="btn primary" type="submit">{{ __('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection