{{-- resources/views/pro/users/form.blade.php --}}
@extends('layouts.base')
@section('title', ($user->exists ? __('Edit user') : __('Create user')))

@section('content')
<div class="wrap">
    <h2 style="margin-bottom:12px;">
        {{ $user->exists ? __('Edit user') : __('Create user') }}
    </h2>

    @if($errors->any())
        <div class="alert danger">
            <ul style="margin:6px 0 0 16px;">@foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
        </div>
    @endif

    <div class="card">
        <form method="POST" action="{{ $user->exists ? route('pro.users.update', $user) : route('pro.users.store') }}">
            @csrf
            @if($user->exists) @method('PUT') @endif

            <div class="form-grid">
                <div class="form-field">
                    <label for="firstname">{{ __('First name') }}</label>
                    <input id="firstname" type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}" required>
                </div>
                <div class="form-field">
                    <label for="lastname">{{ __('Last name') }}</label>
                    <input id="lastname" type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}" required>
                </div>
            </div>

            <div class="form-grid">
                <div class="form-field">
                    <label for="email">{{ __('Email') }}</label>
                    <input id="email" type="email" name="email" value="{{ old('email', $user->email) }}" required>
                </div>
                <div class="form-field">
                    <label for="password">{{ __('Password') }}</label>
                    <input id="password" type="password" name="password" placeholder="{{ $user->exists ? __('Leave blank to keep current') : '' }}">
                </div>
            </div>

            <div class="actions" style="margin-top:12px;">
                <a class="btn" href="{{ route('pro.users.index') }}">{{ __('Back') }}</a>
                <button class="btn primary" type="submit">{{ __('Save') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection