{{-- resources/views/pro/users/import.blade.php --}}
@extends('layouts.base')
@section('title','Pro · Import CSV')

@section('content')
<div class="wrap">
    <h2 style="margin-bottom:12px;">{{ __('Import CSV') }}</h2>

    <div class="card">
        @if($errors->any())
            <div class="alert danger">
                <ul style="margin:6px 0 0 16px;">@foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
            </div>
        @endif

        <p class="muted">{{ __('Expected headers') }}: <code>firstname,lastname,email,password</code></p>

        <form method="POST" action="{{ route('pro.users.import.csv') }}" enctype="multipart/form-data">
            @csrf
            <input type="file" name="file" accept=".csv,text/csv" required>
            <div class="actions" style="margin-top:12px;">
                <a class="btn" href="{{ route('pro.users.index') }}">{{ __('Back') }}</a>
                <button class="btn primary" type="submit">{{ __('Import') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection