{{-- resources/views/pro/users/index.blade.php --}}
@extends('layouts.base')

@section('title', __('Users'))

@section('content')
<div class="wrap">
    <h2 style="margin:0 0 12px;">{{ __('Users of your company') }}</h2>

    <p class="muted" style="margin:8px 0;">
        {{ __('Showing :count users (page :page of :pages)', [
            'count' => $users->total(),
            'page'  => $users->currentPage(),
            'pages' => $users->lastPage(),
        ]) }}
    </p>

    @if(session('ok'))
        <div class="alert success">{{ session('ok') }}</div>
    @endif

    @if($users->isEmpty())
        <div class="alert">{{ __('No user found for your company.') }}</div>
    @else
        <div class="table-responsive">
            <table class="table" style="width:100%;">
                <thead>
                    <tr>
                        <th>{{ __('Lastname') }}</th>
                        <th>{{ __('Firstname') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Role') }}</th>
                        <th>{{ __('Societies') }}</th>
                        <th>{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($users as $u)
                    <tr>
                        <td>{{ $u->lastname ?? '—' }}</td>
                        <td>{{ $u->firstname ?? '—' }}</td>
                        <td>{{ $u->email }}</td>
                        <td>
                            @switch((int)($u->role_id ?? 0))
                                @case(2) {{ __('Admin Pro') }} @break
                                @case(4) {{ __('Pro') }} @break
                                @default  {{ __('User') }}
                            @endswitch
                        </td>
                        <td>
                            @php
                                // Avoid N+1 in production by eager loading in controller if needed
                                $socNames = method_exists($u, 'societies')
                                    ? $u->societies()->pluck('name')->all()
                                    : [];
                            @endphp
                            @if(empty($socNames))
                                <span class="muted">—</span>
                            @else
                                {{ implode(', ', $socNames) }}
                            @endif
                        </td>
                        <td style="white-space:nowrap;">
                            <a class="btn small"
                            href="{{ route('pro.users.edit', ['locale'=>app()->getLocale(), 'user'=>$u->id]) }}">
                                {{ __('Edit') }}
                            </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <div style="margin-top:12px;">
            {{ $users->links() }}
        </div>
    @endif
</div>
@endsection