{{-- resources/views/user/edit.blade.php --}}
@extends('layouts.base')

@section('title', __('My information'))

@section('content')

{{-- DEBUG TEMP --}}
{{-- @php dd($societies?->pluck('name')); @endphp --}}
@php 
    \Log::info('blade:account.edit reached'); 
    $photoUrl = !empty($user->photo) ? Storage::disk('public')->url($user->photo) : null;
@endphp




<div class="profile-page">
    <section class="profile-hero">
        <div class="profile-hero__identity">
            <div class="profile-avatar">
                @if($photoUrl)
                    <img src="{{ $photoUrl }}" alt="{{ $user->name }}">
                @else
                    <span>{{ strtoupper(substr($user->firstname, 0, 1)) }} {{ strtoupper(substr($user->lastname, 0, 1)) }}</span>
                @endif
            </div>
            <div>
                <h1>{{ $user->firstname }} {{ $user->lastname }}</h1>
                <p>{{ $user->email }}</p>
                <div class="profile-status">
                    @if(!$user->email_verified_at)
                        {{-- <span class="badge success">{{ __('Email verified') }}</span>
                    @else --}}
                        {{-- <span class="badge warning">{{ __('Email not verified') }}</span> --}}
                        <form method="POST" action="{{ route('verification.send', ['locale'=>app()->getLocale()]) }}" style="display:inline;"> 
                                @csrf
                                <button class="btn small ghost badge warning" type="submit">{{ __('Email not verified') }}</button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
        


        
        <div class="profile-hero__feedback">
            @if(session('ok'))
                <div class="flash success" role="status">{{ session('ok') }}</div>
            @endif
            @if($errors->any())
                <div class="flash error" role="alert">
                    <ul>
                        @foreach($errors->all() as $e)
                            <li>{{ $e }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
                 {{-- Societies (if any) --}}

                @php
                    $names = $societyNames ?? [];
                    if (empty($names)) {
                        $u = auth()->user();
                        if ($u && (int)$u->id !== 1) {
                            try {
                                $u->loadMissing(['societies:id,name']);
                                $names = $u->societies->pluck('name')->filter()->values()->all();
                            } catch (\Throwable $e) {
                                $names = \DB::table('societydb_user')
                                    ->join('societydb', 'societydb.id', '=', 'societydb_user.society_id')
                                    ->where('societydb_user.user_id', $u->id)
                                    ->orderBy('societydb.name')
                                    ->pluck('societydb.name')
                                    ->all();
                            }
                        }
                    }
                @endphp
                 @auth
                    @if((int)auth()->id() !== 1)
                        {{-- <div class="card" style="margin-top:16px;"> --}}
                            {{-- <div class="card-header">
                                <div class="title">{{ __('Company / Companies') }}</div>
                                <div class="subtitle" style="color:#6b7280;">
                                    {{ __('These links are managed by your administrator.') }}
                                </div>
                            </div> --}}
                            <div class="card-body">
                                @if(!empty($names))
                                    <ul style="list-style:none; padding:0; margin:0; display:grid; gap:.5rem;">
                                        @foreach($names as $name)
                                            <li>
                                                <input type="text" value="{{ $name }}" readonly
                                                    style="width:100%; background:#0e1018; border:1px solid #1f2430; border-radius:8px; padding:.5rem .75rem; color:#c8ccd3;">
                                            </li>
                                        @endforeach
                                    </ul>
                                @else
                                    {{-- <div class="alert" style="margin:0;">
                                        {{ __('No company linked to your account.') }}
                                    </div> --}}
                                @endif
                            </div>
                        {{-- </div> --}}
                    @endif
                @endauth

    </section>

    <div class="profile-grid">
        <section class="profile-card profile-card--main">
            <header>
                <h2>{{ __('Profile') }}</h2>
                <p>{{ __('Update your identity, contact details and security information.') }}</p>
            </header>

            <form method="POST" action="{{ route('user.update', ['locale' => app()->getLocale(), 'user' => $user->id]) }}" enctype="multipart/form-data" class="profile-form">
                @csrf
                @method('PUT')
                <input type="hidden" name="user_id" value="{{ $user->id }}">

                <div class="field-group">
                    <label for="photo">{{ __('Photo') }}</label>
                    <div class="field-group__content">
                        <input id="photo" name="photo" type="file" accept="image/*">
                        <small>{{ __('PNG, JPG ou WEBP · 5 Mo max') }}</small>
                    </div>
                </div>

                <div class="field-grid">
                    <label class="field-group">
                        <span>{{ __('First name') }}</span>
                        <input type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}">
                    </label>
                    <label class="field-group">
                        <span>{{ __('Last name') }}</span>
                        <input type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}">
                    </label>
                </div>

                <div class="field-grid">
                    <label class="field-group">
                        <span>{{ __('Current email') }}</span>
                        <div class="readonly-chip">{{ $user->email }}</div>
                    </label>
                    <label class="field-group">
                        <span>{{ __('Phone') }}</span>
                        <input type="text" name="phone" value="{{ old('phone', $user->phone) }}">
                    </label>
                </div>

                <fieldset class="fieldset">
                    <legend>{{ __('Change password (optional)') }}</legend>
                    <div class="field-grid">
                        <label class="field-group">
                            <span>{{ __('New password') }}</span>
                            <input type="password" name="password" autocomplete="new-password" placeholder="••••••••">
                        </label>
                        <label class="field-group">
                            <span>{{ __('Confirm password') }}</span>
                            <input type="password" name="password_confirmation" autocomplete="new-password" placeholder="••••••••">
                        </label>
                    </div>
                    <small>{{ __('Minimum 8 characters.') }}</small>
                </fieldset>

                <div class="field-grid">
                    <label class="field-group">
                        <span>{{ __('Address 1') }}</span>
                        <input type="text" name="address1" value="{{ old('address1', $user->address1) }}">
                    </label>
                    <label class="field-group">
                        <span>{{ __('Address 2') }}</span>
                        <input type="text" name="address2" value="{{ old('address2', $user->address2) }}">
                    </label>
                </div>

                <div class="field-grid field-grid--thirds">
                    <label class="field-group">
                        <span>{{ __('Postcode') }}</span>
                        <input type="text" name="postcode" value="{{ old('postcode', $user->postcode) }}">
                    </label>
                    <label class="field-group">
                        <span>{{ __('City') }}</span>
                        <input type="text" name="city" value="{{ old('city', $user->city) }}">
                    </label>
                    <label class="field-group">
                        <span>{{ __('Country (ISO)') }}</span>
                        <input type="text" name="country_isocode" maxlength="3" value="{{ old('country_isocode', $user->country_isocode) }}" placeholder="FR">
                    </label>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn primary">{{ __('Save changes') }}</button>
                </div>
            </form>
        </section>

        <aside class="profile-card profile-card--secondary">
            <div class="stack">
 
 
                {{-- @if($user->email_verified_at === null)  {{-- Email is not verified --}}
                  {{-- @  <section class="profile-subcard">
                        <h3>{{ __('Confirm your email') }}</h3>
                        <p>{{ __('Enter the 6-digit code received to validate the change.') }}</p>
                        <form method="POST" action="{{ lr('profile.email.requestCode') }}" class="profile-form">
                            @csrf
                                <input type="hidden" name="current_email" value="{{ auth()->user()->email }}">
                                <input type="hidden" name="new_email" value="{{ auth()->user()->email }}">
                            <div class="form-actions">
                                <button class="btn ghost" type="submit">{{ __('Send verification code') }}</button>
                            </div>
                        </form>
                        <form method="POST" action="{{ lr('profile.email.confirm') }}" class="profile-form">
                            @csrf
                            <label class="field-group">
                                <span>{{ __('Verification code') }}</span>
                                <input type="text" name="code" inputmode="numeric" pattern="\d{6}" placeholder="123456" required>
                            </label>
                            <div class="form-actions">
                                <button class="btn ghost" type="submit">{{ __('Confirm') }}</button>
                            </div>
                        </form>
                    </section>
                @endif --}}

                <section class="profile-subcard danger">
                    <h3>{{ __('Danger zone') }}</h3>
                    <p>{{ __('Delete your account permanently. This action cannot be undone.') }}</p>
                    <form method="POST" action="{{ route('user.destroy', ['locale' => app()->getLocale(), 'user' => $user->id]) }}" onsubmit="return confirm('{{ __('Are you sure you want to delete your account? This cannot be undone.') }}')">
                        @csrf
                        @method('DELETE')
                        
                        <button type="submit" class="btn danger full">{{ __('Delete account') }}</button>
                    </form>
                </section>

                @if(!empty($user->pending_email))
                    <section class="profile-subcard">
                        <h3>{{ __('Confirm your new email') }}</h3>
                        <p>{{ __('Enter the validation code we sent to finish the update.') }}</p>
                        <form method="POST" action="{{ lr('user.verifyEmail', ['user' => $user->id]) }}" class="profile-form">
                            @csrf
                            <label class="field-group">
                                <span>{{ __('Verification code') }}</span>
                                <input type="text" inputmode="numeric" pattern="[0-9]*" name="code" maxlength="6" placeholder="123456" required>
                            </label>
                            <div class="form-actions">
                                <button type="submit" class="btn primary">{{ __('Validate code') }}</button>
                            </div>
                        </form>
                    </section>
                @endif
            </div>
        </aside>
    </div>

    @if(!empty($users))
        <section class="profile-card profile-card--full">
            <header>
                <h2>{{ __('Team activity') }}</h2>
                <p>{{ __('Monitor who is online and their recent activity (admins only).') }}</p>
            </header>
            <div class="table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Last activity') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $u)
                            <tr>
                                <td>
                                    <div class="user-cell">
                                        <div class="avatar-small">{{ strtoupper(substr($u->name, 0, 1)) }}</div>
                                        <div>
                                            <strong>{{ $u->name }}</strong><br>
                                            <small>{{ $u->email }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($u->is_online)
                                        <span class="status-chip online">{{ __('Online') }}</span>
                                    @else
                                        <span class="status-chip offline">{{ __('Offline') }}</span>
                                    @endif
                                </td>
                                <td>
                                    @if($u->last_seen)
                                        <span title="{{ $u->last_seen->toDateTimeString() }}">{{ $u->last_seen->diffForHumans() }}</span>
                                    @else
                                        —
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </section>
    @endif
</div>


@endsection