{{-- resources/views/auth/login.blade.php --}}
@extends('layouts.base')

@section('title', __('Login'))

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <div class="wrap">
    <h2>{{ __('login') }}</h2>

    @if(session('error'))
        <div class="alert danger">{{ session('error') }}</div>
    @endif

    @if($errors->any())
        <div class="alert danger">
        <ul style="margin:0 0 0 16px;">
            @foreach($errors->all() as $err)<li>{{ $err }}</li>@endforeach
        </ul>
        </div>
    @endif

    <section class="profile-card profile-card--main">

        <form method="POST" action="{{ route('login.post', ['locale' => app()->getLocale()]) }}" class="profile-form">
            @csrf
            <div class="" style="padding:16px; border-radius:12px; border:1px solid #e5e7eb; background:#fff;">

                <div class="profile-card profile-card--main">
                    <div class="field-grid">
                        <div class="field-group">
                            <label for="email">{{ __('Email') }}</label>
                            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus>
                        </div>
                        <div class="field-group">
                            <label for="password">{{ __('Password') }}</label>
                            <input id="password" type="password" name="password" required>
                        </div>
                    </div>
                </div>

                <div class="field-grid actions">
                    <div class="field-group">
                        <label>
                            <input type="checkbox" name="remember"> {{ __('Remember me') }}
                        </label>
                    </div>
                    <div class="field-group">
                        <button type="submit" class="btn primary">{{ __('Login') }}</button>
                    </div>
                    <div class="field-group">
                       <a href="{{ route('register', ['locale' => app()->getLocale()]) }}" class="btn ghost">{{ __('Create account') }}</a>
                    </div>
                </div>

                   {{-- 🔗 Lien mot de passe oublié --}}
                <div style="margin-top:10px; text-align:right; font-size: 0.9em;">
                    <a class="btn ghost" href="{{ route('password.request') }}">{{ __('Forgot your password?') }}</a>
                </div>
            </div>
        </form>
    </section>
 @endsection